/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationshipValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationshipValue> {
    private static final SdkField<String> TARGET_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetEntityId").getter(RelationshipValue.getter(RelationshipValue::targetEntityId)).setter(RelationshipValue.setter(Builder::targetEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEntityId").build()}).build();
    private static final SdkField<String> TARGET_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetComponentName").getter(RelationshipValue.getter(RelationshipValue::targetComponentName)).setter(RelationshipValue.setter(Builder::targetComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetComponentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ENTITY_ID_FIELD, TARGET_COMPONENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetEntityId;
    private final String targetComponentName;

    private RelationshipValue(BuilderImpl builder) {
        this.targetEntityId = builder.targetEntityId;
        this.targetComponentName = builder.targetComponentName;
    }

    public final String targetEntityId() {
        return this.targetEntityId;
    }

    public final String targetComponentName() {
        return this.targetComponentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetComponentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationshipValue)) {
            return false;
        }
        RelationshipValue other = (RelationshipValue)obj;
        return Objects.equals(this.targetEntityId(), other.targetEntityId()) && Objects.equals(this.targetComponentName(), other.targetComponentName());
    }

    public final String toString() {
        return ToString.builder((String)"RelationshipValue").add("TargetEntityId", (Object)this.targetEntityId()).add("TargetComponentName", (Object)this.targetComponentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetEntityId": {
                return Optional.ofNullable(clazz.cast(this.targetEntityId()));
            }
            case "targetComponentName": {
                return Optional.ofNullable(clazz.cast(this.targetComponentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationshipValue, T> g) {
        return obj -> g.apply((RelationshipValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetEntityId;
        private String targetComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationshipValue model) {
            this.targetEntityId(model.targetEntityId);
            this.targetComponentName(model.targetComponentName);
        }

        public final String getTargetEntityId() {
            return this.targetEntityId;
        }

        public final void setTargetEntityId(String targetEntityId) {
            this.targetEntityId = targetEntityId;
        }

        @Override
        public final Builder targetEntityId(String targetEntityId) {
            this.targetEntityId = targetEntityId;
            return this;
        }

        public final String getTargetComponentName() {
            return this.targetComponentName;
        }

        public final void setTargetComponentName(String targetComponentName) {
            this.targetComponentName = targetComponentName;
        }

        @Override
        public final Builder targetComponentName(String targetComponentName) {
            this.targetComponentName = targetComponentName;
            return this;
        }

        public RelationshipValue build() {
            return new RelationshipValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationshipValue> {
        public Builder targetEntityId(String var1);

        public Builder targetComponentName(String var1);
    }
}

