/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkerFleetRequest extends IotRoboRunnerRequest implements
        ToCopyableBuilder<CreateWorkerFleetRequest.Builder, CreateWorkerFleetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateWorkerFleetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateWorkerFleetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SITE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("site")
            .getter(getter(CreateWorkerFleetRequest::site)).setter(setter(Builder::site))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("site").build()).build();

    private static final SdkField<String> ADDITIONAL_FIXED_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalFixedProperties").getter(getter(CreateWorkerFleetRequest::additionalFixedProperties))
            .setter(setter(Builder::additionalFixedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFixedProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, SITE_FIELD, ADDITIONAL_FIXED_PROPERTIES_FIELD));

    private final String clientToken;

    private final String name;

    private final String site;

    private final String additionalFixedProperties;

    private CreateWorkerFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.site = builder.site;
        this.additionalFixedProperties = builder.additionalFixedProperties;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Site property for this object.
     * 
     * @return The value of the Site property for this object.
     */
    public final String site() {
        return site;
    }

    /**
     * Returns the value of the AdditionalFixedProperties property for this object.
     * 
     * @return The value of the AdditionalFixedProperties property for this object.
     */
    public final String additionalFixedProperties() {
        return additionalFixedProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(site());
        hashCode = 31 * hashCode + Objects.hashCode(additionalFixedProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkerFleetRequest)) {
            return false;
        }
        CreateWorkerFleetRequest other = (CreateWorkerFleetRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(site(), other.site())
                && Objects.equals(additionalFixedProperties(), other.additionalFixedProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkerFleetRequest").add("ClientToken", clientToken()).add("Name", name())
                .add("Site", site()).add("AdditionalFixedProperties", additionalFixedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "site":
            return Optional.ofNullable(clazz.cast(site()));
        case "additionalFixedProperties":
            return Optional.ofNullable(clazz.cast(additionalFixedProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkerFleetRequest, T> g) {
        return obj -> g.apply((CreateWorkerFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRoboRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkerFleetRequest> {
        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Site property for this object.
         *
         * @param site
         *        The new value for the Site property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder site(String site);

        /**
         * Sets the value of the AdditionalFixedProperties property for this object.
         *
         * @param additionalFixedProperties
         *        The new value for the AdditionalFixedProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFixedProperties(String additionalFixedProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRoboRunnerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private String site;

        private String additionalFixedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkerFleetRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            site(model.site);
            additionalFixedProperties(model.additionalFixedProperties);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSite() {
            return site;
        }

        public final void setSite(String site) {
            this.site = site;
        }

        @Override
        public final Builder site(String site) {
            this.site = site;
            return this;
        }

        public final String getAdditionalFixedProperties() {
            return additionalFixedProperties;
        }

        public final void setAdditionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
        }

        @Override
        public final Builder additionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkerFleetRequest build() {
            return new CreateWorkerFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
