/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.NotificationConfigurationSummary;

public class ListNotificationConfigurationsPublisher
implements SdkPublisher<ListNotificationConfigurationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListNotificationConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListNotificationConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListNotificationConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationConfigurationSummary> notificationConfigurationList() {
        Function<ListNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationConfigurationList() != null) {
                return response.notificationConfigurationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListNotificationConfigurationsResponse> {
        private ListNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationConfigurationsResponse> nextPage(ListNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationConfigurationsPublisher.this.client.listNotificationConfigurations(ListNotificationConfigurationsPublisher.this.firstRequest);
            }
            return ListNotificationConfigurationsPublisher.this.client.listNotificationConfigurations((ListNotificationConfigurationsRequest)((Object)ListNotificationConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

