/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReport;
import software.amazon.awssdk.services.iotmanagedintegrations.model.HubNetworkMode;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MetaDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateManagedThingRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, UpdateManagedThingRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::identifier)).setter(UpdateManagedThingRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::owner)).setter(UpdateManagedThingRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> CREDENTIAL_LOCKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialLockerId").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::credentialLockerId)).setter(UpdateManagedThingRequest.setter(Builder::credentialLockerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialLockerId").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::serialNumber)).setter(UpdateManagedThingRequest.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::brand)).setter(UpdateManagedThingRequest.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::model)).setter(UpdateManagedThingRequest.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::name)).setter(UpdateManagedThingRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CapabilityReport> CAPABILITY_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapabilityReport").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::capabilityReport)).setter(UpdateManagedThingRequest.setter(Builder::capabilityReport)).constructor(CapabilityReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()}).build();
    private static final SdkField<String> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Capabilities").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::capabilities)).setter(UpdateManagedThingRequest.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::classification)).setter(UpdateManagedThingRequest.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> HUB_NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubNetworkMode").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::hubNetworkModeAsString)).setter(UpdateManagedThingRequest.setter(Builder::hubNetworkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubNetworkMode").build()}).build();
    private static final SdkField<Map<String, String>> META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetaData").getter(UpdateManagedThingRequest.getter(UpdateManagedThingRequest::metaData)).setter(UpdateManagedThingRequest.setter(Builder::metaData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, OWNER_FIELD, CREDENTIAL_LOCKER_ID_FIELD, SERIAL_NUMBER_FIELD, BRAND_FIELD, MODEL_FIELD, NAME_FIELD, CAPABILITY_REPORT_FIELD, CAPABILITIES_FIELD, CLASSIFICATION_FIELD, HUB_NETWORK_MODE_FIELD, META_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateManagedThingRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String owner;
    private final String credentialLockerId;
    private final String serialNumber;
    private final String brand;
    private final String model;
    private final String name;
    private final CapabilityReport capabilityReport;
    private final String capabilities;
    private final String classification;
    private final String hubNetworkMode;
    private final Map<String, String> metaData;

    private UpdateManagedThingRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.owner = builder.owner;
        this.credentialLockerId = builder.credentialLockerId;
        this.serialNumber = builder.serialNumber;
        this.brand = builder.brand;
        this.model = builder.model;
        this.name = builder.name;
        this.capabilityReport = builder.capabilityReport;
        this.capabilities = builder.capabilities;
        this.classification = builder.classification;
        this.hubNetworkMode = builder.hubNetworkMode;
        this.metaData = builder.metaData;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String owner() {
        return this.owner;
    }

    public final String credentialLockerId() {
        return this.credentialLockerId;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String brand() {
        return this.brand;
    }

    public final String model() {
        return this.model;
    }

    public final String name() {
        return this.name;
    }

    public final CapabilityReport capabilityReport() {
        return this.capabilityReport;
    }

    public final String capabilities() {
        return this.capabilities;
    }

    public final String classification() {
        return this.classification;
    }

    public final HubNetworkMode hubNetworkMode() {
        return HubNetworkMode.fromValue(this.hubNetworkMode);
    }

    public final String hubNetworkModeAsString() {
        return this.hubNetworkMode;
    }

    public final boolean hasMetaData() {
        return this.metaData != null && !(this.metaData instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metaData() {
        return this.metaData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialLockerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.brand());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubNetworkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetaData() ? this.metaData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedThingRequest)) {
            return false;
        }
        UpdateManagedThingRequest other = (UpdateManagedThingRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.credentialLockerId(), other.credentialLockerId()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.brand(), other.brand()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.capabilityReport(), other.capabilityReport()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.hubNetworkModeAsString(), other.hubNetworkModeAsString()) && this.hasMetaData() == other.hasMetaData() && Objects.equals(this.metaData(), other.metaData());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateManagedThingRequest").add("Identifier", (Object)this.identifier()).add("Owner", (Object)(this.owner() == null ? null : "*** Sensitive Data Redacted ***")).add("CredentialLockerId", (Object)this.credentialLockerId()).add("SerialNumber", (Object)(this.serialNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Brand", (Object)(this.brand() == null ? null : "*** Sensitive Data Redacted ***")).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("CapabilityReport", (Object)this.capabilityReport()).add("Capabilities", (Object)this.capabilities()).add("Classification", (Object)(this.classification() == null ? null : "*** Sensitive Data Redacted ***")).add("HubNetworkMode", (Object)this.hubNetworkModeAsString()).add("MetaData", this.hasMetaData() ? this.metaData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CredentialLockerId": {
                return Optional.ofNullable(clazz.cast(this.credentialLockerId()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brand()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CapabilityReport": {
                return Optional.ofNullable(clazz.cast(this.capabilityReport()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "HubNetworkMode": {
                return Optional.ofNullable(clazz.cast(this.hubNetworkModeAsString()));
            }
            case "MetaData": {
                return Optional.ofNullable(clazz.cast(this.metaData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CredentialLockerId", CREDENTIAL_LOCKER_ID_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("HubNetworkMode", HUB_NETWORK_MODE_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateManagedThingRequest, T> g) {
        return obj -> g.apply((UpdateManagedThingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String owner;
        private String credentialLockerId;
        private String serialNumber;
        private String brand;
        private String model;
        private String name;
        private CapabilityReport capabilityReport;
        private String capabilities;
        private String classification;
        private String hubNetworkMode;
        private Map<String, String> metaData = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedThingRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.owner(model.owner);
            this.credentialLockerId(model.credentialLockerId);
            this.serialNumber(model.serialNumber);
            this.brand(model.brand);
            this.model(model.model);
            this.name(model.name);
            this.capabilityReport(model.capabilityReport);
            this.capabilities(model.capabilities);
            this.classification(model.classification);
            this.hubNetworkMode(model.hubNetworkMode);
            this.metaData(model.metaData);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getCredentialLockerId() {
            return this.credentialLockerId;
        }

        public final void setCredentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
        }

        @Override
        public final Builder credentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CapabilityReport.Builder getCapabilityReport() {
            return this.capabilityReport != null ? this.capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(CapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(CapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        public final String getCapabilities() {
            return this.capabilities;
        }

        public final void setCapabilities(String capabilities) {
            this.capabilities = capabilities;
        }

        @Override
        public final Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getHubNetworkMode() {
            return this.hubNetworkMode;
        }

        public final void setHubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
        }

        @Override
        public final Builder hubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
            return this;
        }

        @Override
        public final Builder hubNetworkMode(HubNetworkMode hubNetworkMode) {
            this.hubNetworkMode(hubNetworkMode == null ? null : hubNetworkMode.toString());
            return this;
        }

        public final Map<String, String> getMetaData() {
            if (this.metaData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metaData;
        }

        public final void setMetaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
        }

        @Override
        public final Builder metaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateManagedThingRequest build() {
            return new UpdateManagedThingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateManagedThingRequest> {
        public Builder identifier(String var1);

        public Builder owner(String var1);

        public Builder credentialLockerId(String var1);

        public Builder serialNumber(String var1);

        public Builder brand(String var1);

        public Builder model(String var1);

        public Builder name(String var1);

        public Builder capabilityReport(CapabilityReport var1);

        default public Builder capabilityReport(Consumer<CapabilityReport.Builder> capabilityReport) {
            return this.capabilityReport((CapabilityReport)((CapabilityReport.Builder)CapabilityReport.builder().applyMutation(capabilityReport)).build());
        }

        public Builder capabilities(String var1);

        public Builder classification(String var1);

        public Builder hubNetworkMode(String var1);

        public Builder hubNetworkMode(HubNetworkMode var1);

        public Builder metaData(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

