/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionSummaries;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionSummariesListDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOtaTaskExecutionsResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, ListOtaTaskExecutionsResponse> {
    private static final SdkField<List<OtaTaskExecutionSummaries>> EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExecutionSummaries").getter(ListOtaTaskExecutionsResponse.getter(ListOtaTaskExecutionsResponse::executionSummaries)).setter(ListOtaTaskExecutionsResponse.setter(Builder::executionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OtaTaskExecutionSummaries::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOtaTaskExecutionsResponse.getter(ListOtaTaskExecutionsResponse::nextToken)).setter(ListOtaTaskExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOtaTaskExecutionsResponse.memberNameToFieldInitializer();
    private final List<OtaTaskExecutionSummaries> executionSummaries;
    private final String nextToken;

    private ListOtaTaskExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionSummaries = builder.executionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExecutionSummaries() {
        return this.executionSummaries != null && !(this.executionSummaries instanceof SdkAutoConstructList);
    }

    public final List<OtaTaskExecutionSummaries> executionSummaries() {
        return this.executionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionSummaries() ? this.executionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOtaTaskExecutionsResponse)) {
            return false;
        }
        ListOtaTaskExecutionsResponse other = (ListOtaTaskExecutionsResponse)((Object)obj);
        return this.hasExecutionSummaries() == other.hasExecutionSummaries() && Objects.equals(this.executionSummaries(), other.executionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOtaTaskExecutionsResponse").add("ExecutionSummaries", this.hasExecutionSummaries() ? this.executionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.executionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionSummaries", EXECUTION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOtaTaskExecutionsResponse, T> g) {
        return obj -> g.apply((ListOtaTaskExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<OtaTaskExecutionSummaries> executionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOtaTaskExecutionsResponse model) {
            super(model);
            this.executionSummaries(model.executionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<OtaTaskExecutionSummaries.Builder> getExecutionSummaries() {
            List<OtaTaskExecutionSummaries.Builder> result = OtaTaskExecutionSummariesListDefinitionCopier.copyToBuilder(this.executionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionSummaries(Collection<OtaTaskExecutionSummaries.BuilderImpl> executionSummaries) {
            this.executionSummaries = OtaTaskExecutionSummariesListDefinitionCopier.copyFromBuilder(executionSummaries);
        }

        @Override
        public final Builder executionSummaries(Collection<OtaTaskExecutionSummaries> executionSummaries) {
            this.executionSummaries = OtaTaskExecutionSummariesListDefinitionCopier.copy(executionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(OtaTaskExecutionSummaries ... executionSummaries) {
            this.executionSummaries(Arrays.asList(executionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(Consumer<OtaTaskExecutionSummaries.Builder> ... executionSummaries) {
            this.executionSummaries(Stream.of(executionSummaries).map(c -> (OtaTaskExecutionSummaries)((OtaTaskExecutionSummaries.Builder)OtaTaskExecutionSummaries.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOtaTaskExecutionsResponse build() {
            return new ListOtaTaskExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOtaTaskExecutionsResponse> {
        public Builder executionSummaries(Collection<OtaTaskExecutionSummaries> var1);

        public Builder executionSummaries(OtaTaskExecutionSummaries ... var1);

        public Builder executionSummaries(Consumer<OtaTaskExecutionSummaries.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

