/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HubNetworkMode {
    STANDARD("STANDARD"),
    NETWORK_WIDE_EXCLUSION("NETWORK_WIDE_EXCLUSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HubNetworkMode> VALUE_MAP;
    private final String value;

    private HubNetworkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HubNetworkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HubNetworkMode> knownValues() {
        EnumSet<HubNetworkMode> knownValues = EnumSet.allOf(HubNetworkMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HubNetworkMode.class, HubNetworkMode::toString);
    }
}

