/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConfigurationError;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConfigurationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationStatus> {
    private static final SdkField<ConfigurationError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ConfigurationStatus.getter(ConfigurationStatus::error)).setter(ConfigurationStatus.setter(Builder::error)).constructor(ConfigurationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ConfigurationStatus.getter(ConfigurationStatus::stateAsString)).setter(ConfigurationStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConfigurationError error;
    private final String state;

    private ConfigurationStatus(BuilderImpl builder) {
        this.error = builder.error;
        this.state = builder.state;
    }

    public final ConfigurationError error() {
        return this.error;
    }

    public final ConfigurationState state() {
        return ConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationStatus)) {
            return false;
        }
        ConfigurationStatus other = (ConfigurationStatus)obj;
        return Objects.equals(this.error(), other.error()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationStatus").add("Error", (Object)this.error()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("error", ERROR_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationStatus, T> g) {
        return obj -> g.apply((ConfigurationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfigurationError error;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationStatus model) {
            this.error(model.error);
            this.state(model.state);
        }

        public final ConfigurationError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ConfigurationError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ConfigurationError error) {
            this.error = error;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public ConfigurationStatus build() {
            return new ConfigurationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationStatus> {
        public Builder error(ConfigurationError var1);

        default public Builder error(Consumer<ConfigurationError.Builder> error) {
            return this.error((ConfigurationError)((ConfigurationError.Builder)ConfigurationError.builder().applyMutation(error)).build());
        }

        public Builder state(String var1);

        public Builder state(ConfigurationState var1);
    }
}

