/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.QueryFilter;
import software.amazon.awssdk.services.iotanalytics.model.QueryFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlQueryDatasetAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlQueryDatasetAction> {
    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sqlQuery").getter(SqlQueryDatasetAction.getter(SqlQueryDatasetAction::sqlQuery)).setter(SqlQueryDatasetAction.setter(Builder::sqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlQuery").build()}).build();
    private static final SdkField<List<QueryFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(SqlQueryDatasetAction.getter(SqlQueryDatasetAction::filters)).setter(SqlQueryDatasetAction.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_QUERY_FIELD, FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sqlQuery;
    private final List<QueryFilter> filters;

    private SqlQueryDatasetAction(BuilderImpl builder) {
        this.sqlQuery = builder.sqlQuery;
        this.filters = builder.filters;
    }

    public final String sqlQuery() {
        return this.sqlQuery;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<QueryFilter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlQueryDatasetAction)) {
            return false;
        }
        SqlQueryDatasetAction other = (SqlQueryDatasetAction)obj;
        return Objects.equals(this.sqlQuery(), other.sqlQuery()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"SqlQueryDatasetAction").add("SqlQuery", (Object)this.sqlQuery()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sqlQuery": {
                return Optional.ofNullable(clazz.cast(this.sqlQuery()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlQueryDatasetAction, T> g) {
        return obj -> g.apply((SqlQueryDatasetAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sqlQuery;
        private List<QueryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlQueryDatasetAction model) {
            this.sqlQuery(model.sqlQuery);
            this.filters(model.filters);
        }

        public final String getSqlQuery() {
            return this.sqlQuery;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        @Override
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final List<QueryFilter.Builder> getFilters() {
            List<QueryFilter.Builder> result = QueryFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QueryFilter.BuilderImpl> filters) {
            this.filters = QueryFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<QueryFilter> filters) {
            this.filters = QueryFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(QueryFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<QueryFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (QueryFilter)((QueryFilter.Builder)QueryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SqlQueryDatasetAction build() {
            return new SqlQueryDatasetAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlQueryDatasetAction> {
        public Builder sqlQuery(String var1);

        public Builder filters(Collection<QueryFilter> var1);

        public Builder filters(QueryFilter ... var1);

        public Builder filters(Consumer<QueryFilter.Builder> ... var1);
    }
}

