/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.MitigationActionIdentifier;

public class ListMitigationActionsIterable
implements SdkIterable<ListMitigationActionsResponse> {
    private final IotClient client;
    private final ListMitigationActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMitigationActionsIterable(IotClient client, ListMitigationActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMitigationActionsResponseFetcher();
    }

    public Iterator<ListMitigationActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MitigationActionIdentifier> actionIdentifiers() {
        Function<ListMitigationActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionIdentifiers() != null) {
                return response.actionIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMitigationActionsResponseFetcher
    implements SyncPageFetcher<ListMitigationActionsResponse> {
        private ListMitigationActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMitigationActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMitigationActionsResponse nextPage(ListMitigationActionsResponse previousPage) {
            if (previousPage == null) {
                return ListMitigationActionsIterable.this.client.listMitigationActions(ListMitigationActionsIterable.this.firstRequest);
            }
            return ListMitigationActionsIterable.this.client.listMitigationActions((ListMitigationActionsRequest)((Object)ListMitigationActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

