/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.FleetMetricNameAndArn;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse;

public class ListFleetMetricsIterable
implements SdkIterable<ListFleetMetricsResponse> {
    private final IotClient client;
    private final ListFleetMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetMetricsIterable(IotClient client, ListFleetMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFleetMetricsResponseFetcher();
    }

    public Iterator<ListFleetMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetMetricNameAndArn> fleetMetrics() {
        Function<ListFleetMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetMetrics() != null) {
                return response.fleetMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetMetricsResponseFetcher
    implements SyncPageFetcher<ListFleetMetricsResponse> {
        private ListFleetMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetMetricsResponse nextPage(ListFleetMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetMetricsIterable.this.client.listFleetMetrics(ListFleetMetricsIterable.this.firstRequest);
            }
            return ListFleetMetricsIterable.this.client.listFleetMetrics((ListFleetMetricsRequest)((Object)ListFleetMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

