/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventConfigurationsRequest extends IotRequest implements
        ToCopyableBuilder<UpdateEventConfigurationsRequest.Builder, UpdateEventConfigurationsRequest> {
    private static final SdkField<Map<String, Configuration>> EVENT_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, Configuration>> builder(MarshallingType.MAP)
            .memberName("eventConfigurations")
            .getter(getter(UpdateEventConfigurationsRequest::eventConfigurationsAsStrings))
            .setter(setter(Builder::eventConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, Configuration> eventConfigurations;

    private UpdateEventConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.eventConfigurations = builder.eventConfigurations;
    }

    /**
     * <p>
     * The new event configuration values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventConfigurations} method.
     * </p>
     * 
     * @return The new event configuration values.
     */
    public final Map<EventType, Configuration> eventConfigurations() {
        return EventConfigurationsCopier.copyStringToEnum(eventConfigurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventConfigurations() {
        return eventConfigurations != null && !(eventConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The new event configuration values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventConfigurations} method.
     * </p>
     * 
     * @return The new event configuration values.
     */
    public final Map<String, Configuration> eventConfigurationsAsStrings() {
        return eventConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventConfigurations() ? eventConfigurationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventConfigurationsRequest)) {
            return false;
        }
        UpdateEventConfigurationsRequest other = (UpdateEventConfigurationsRequest) obj;
        return hasEventConfigurations() == other.hasEventConfigurations()
                && Objects.equals(eventConfigurationsAsStrings(), other.eventConfigurationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventConfigurationsRequest")
                .add("EventConfigurations", hasEventConfigurations() ? eventConfigurationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventConfigurations":
            return Optional.ofNullable(clazz.cast(eventConfigurationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventConfigurations", EVENT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventConfigurationsRequest, T> g) {
        return obj -> g.apply((UpdateEventConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventConfigurationsRequest> {
        /**
         * <p>
         * The new event configuration values.
         * </p>
         * 
         * @param eventConfigurations
         *        The new event configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations);

        /**
         * <p>
         * The new event configuration values.
         * </p>
         * 
         * @param eventConfigurations
         *        The new event configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Map<String, Configuration> eventConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventConfigurationsRequest model) {
            super(model);
            eventConfigurationsWithStrings(model.eventConfigurations);
        }

        public final Map<String, Configuration.Builder> getEventConfigurations() {
            Map<String, Configuration.Builder> result = EventConfigurationsCopier.copyToBuilder(this.eventConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEventConfigurations(Map<String, Configuration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        @Override
        public final Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        public final Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyEnumToString(eventConfigurations);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventConfigurationsRequest build() {
            return new UpdateEventConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
