/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of
 * searchable thing attribute names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingTypeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingTypeProperties.Builder, ThingTypeProperties> {
    private static final SdkField<String> THING_TYPE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeDescription").getter(getter(ThingTypeProperties::thingTypeDescription))
            .setter(setter(Builder::thingTypeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeDescription").build())
            .build();

    private static final SdkField<List<String>> SEARCHABLE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("searchableAttributes")
            .getter(getter(ThingTypeProperties::searchableAttributes))
            .setter(setter(Builder::searchableAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchableAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Mqtt5Configuration> MQTT5_CONFIGURATION_FIELD = SdkField
            .<Mqtt5Configuration> builder(MarshallingType.SDK_POJO).memberName("mqtt5Configuration")
            .getter(getter(ThingTypeProperties::mqtt5Configuration)).setter(setter(Builder::mqtt5Configuration))
            .constructor(Mqtt5Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mqtt5Configuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_DESCRIPTION_FIELD,
            SEARCHABLE_ATTRIBUTES_FIELD, MQTT5_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thingTypeDescription;

    private final List<String> searchableAttributes;

    private final Mqtt5Configuration mqtt5Configuration;

    private ThingTypeProperties(BuilderImpl builder) {
        this.thingTypeDescription = builder.thingTypeDescription;
        this.searchableAttributes = builder.searchableAttributes;
        this.mqtt5Configuration = builder.mqtt5Configuration;
    }

    /**
     * <p>
     * The description of the thing type.
     * </p>
     * 
     * @return The description of the thing type.
     */
    public final String thingTypeDescription() {
        return thingTypeDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchableAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSearchableAttributes() {
        return searchableAttributes != null && !(searchableAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of searchable thing attribute names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchableAttributes} method.
     * </p>
     * 
     * @return A list of searchable thing attribute names.
     */
    public final List<String> searchableAttributes() {
        return searchableAttributes;
    }

    /**
     * <p>
     * The configuration to add user-defined properties to enrich MQTT 5 messages.
     * </p>
     * 
     * @return The configuration to add user-defined properties to enrich MQTT 5 messages.
     */
    public final Mqtt5Configuration mqtt5Configuration() {
        return mqtt5Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchableAttributes() ? searchableAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mqtt5Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeProperties)) {
            return false;
        }
        ThingTypeProperties other = (ThingTypeProperties) obj;
        return Objects.equals(thingTypeDescription(), other.thingTypeDescription())
                && hasSearchableAttributes() == other.hasSearchableAttributes()
                && Objects.equals(searchableAttributes(), other.searchableAttributes())
                && Objects.equals(mqtt5Configuration(), other.mqtt5Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingTypeProperties").add("ThingTypeDescription", thingTypeDescription())
                .add("SearchableAttributes", hasSearchableAttributes() ? searchableAttributes() : null)
                .add("Mqtt5Configuration", mqtt5Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeDescription":
            return Optional.ofNullable(clazz.cast(thingTypeDescription()));
        case "searchableAttributes":
            return Optional.ofNullable(clazz.cast(searchableAttributes()));
        case "mqtt5Configuration":
            return Optional.ofNullable(clazz.cast(mqtt5Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingTypeDescription", THING_TYPE_DESCRIPTION_FIELD);
        map.put("searchableAttributes", SEARCHABLE_ATTRIBUTES_FIELD);
        map.put("mqtt5Configuration", MQTT5_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThingTypeProperties, T> g) {
        return obj -> g.apply((ThingTypeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingTypeProperties> {
        /**
         * <p>
         * The description of the thing type.
         * </p>
         * 
         * @param thingTypeDescription
         *        The description of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeDescription(String thingTypeDescription);

        /**
         * <p>
         * A list of searchable thing attribute names.
         * </p>
         * 
         * @param searchableAttributes
         *        A list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchableAttributes(Collection<String> searchableAttributes);

        /**
         * <p>
         * A list of searchable thing attribute names.
         * </p>
         * 
         * @param searchableAttributes
         *        A list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchableAttributes(String... searchableAttributes);

        /**
         * <p>
         * The configuration to add user-defined properties to enrich MQTT 5 messages.
         * </p>
         * 
         * @param mqtt5Configuration
         *        The configuration to add user-defined properties to enrich MQTT 5 messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mqtt5Configuration(Mqtt5Configuration mqtt5Configuration);

        /**
         * <p>
         * The configuration to add user-defined properties to enrich MQTT 5 messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link Mqtt5Configuration.Builder} avoiding the
         * need to create one manually via {@link Mqtt5Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mqtt5Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #mqtt5Configuration(Mqtt5Configuration)}.
         * 
         * @param mqtt5Configuration
         *        a consumer that will call methods on {@link Mqtt5Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mqtt5Configuration(Mqtt5Configuration)
         */
        default Builder mqtt5Configuration(Consumer<Mqtt5Configuration.Builder> mqtt5Configuration) {
            return mqtt5Configuration(Mqtt5Configuration.builder().applyMutation(mqtt5Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingTypeDescription;

        private List<String> searchableAttributes = DefaultSdkAutoConstructList.getInstance();

        private Mqtt5Configuration mqtt5Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeProperties model) {
            thingTypeDescription(model.thingTypeDescription);
            searchableAttributes(model.searchableAttributes);
            mqtt5Configuration(model.mqtt5Configuration);
        }

        public final String getThingTypeDescription() {
            return thingTypeDescription;
        }

        public final void setThingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
        }

        @Override
        public final Builder thingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
            return this;
        }

        public final Collection<String> getSearchableAttributes() {
            if (searchableAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return searchableAttributes;
        }

        public final void setSearchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
        }

        @Override
        public final Builder searchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchableAttributes(String... searchableAttributes) {
            searchableAttributes(Arrays.asList(searchableAttributes));
            return this;
        }

        public final Mqtt5Configuration.Builder getMqtt5Configuration() {
            return mqtt5Configuration != null ? mqtt5Configuration.toBuilder() : null;
        }

        public final void setMqtt5Configuration(Mqtt5Configuration.BuilderImpl mqtt5Configuration) {
            this.mqtt5Configuration = mqtt5Configuration != null ? mqtt5Configuration.build() : null;
        }

        @Override
        public final Builder mqtt5Configuration(Mqtt5Configuration mqtt5Configuration) {
            this.mqtt5Configuration = mqtt5Configuration;
            return this;
        }

        @Override
        public ThingTypeProperties build() {
            return new ThingTypeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
