/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the code-signing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningProfileParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningProfileParameter.Builder, SigningProfileParameter> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(SigningProfileParameter::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(SigningProfileParameter::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> CERTIFICATE_PATH_ON_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePathOnDevice").getter(getter(SigningProfileParameter::certificatePathOnDevice))
            .setter(setter(Builder::certificatePathOnDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePathOnDevice").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            PLATFORM_FIELD, CERTIFICATE_PATH_ON_DEVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String platform;

    private final String certificatePathOnDevice;

    private SigningProfileParameter(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.platform = builder.platform;
        this.certificatePathOnDevice = builder.certificatePathOnDevice;
    }

    /**
     * <p>
     * Certificate ARN.
     * </p>
     * 
     * @return Certificate ARN.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The hardware platform of your device.
     * </p>
     * 
     * @return The hardware platform of your device.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The location of the code-signing certificate on your device.
     * </p>
     * 
     * @return The location of the code-signing certificate on your device.
     */
    public final String certificatePathOnDevice() {
        return certificatePathOnDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePathOnDevice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfileParameter)) {
            return false;
        }
        SigningProfileParameter other = (SigningProfileParameter) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(platform(), other.platform())
                && Objects.equals(certificatePathOnDevice(), other.certificatePathOnDevice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningProfileParameter").add("CertificateArn", certificateArn()).add("Platform", platform())
                .add("CertificatePathOnDevice", certificatePathOnDevice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "certificatePathOnDevice":
            return Optional.ofNullable(clazz.cast(certificatePathOnDevice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("certificatePathOnDevice", CERTIFICATE_PATH_ON_DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SigningProfileParameter, T> g) {
        return obj -> g.apply((SigningProfileParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningProfileParameter> {
        /**
         * <p>
         * Certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        Certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The hardware platform of your device.
         * </p>
         * 
         * @param platform
         *        The hardware platform of your device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The location of the code-signing certificate on your device.
         * </p>
         * 
         * @param certificatePathOnDevice
         *        The location of the code-signing certificate on your device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePathOnDevice(String certificatePathOnDevice);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String platform;

        private String certificatePathOnDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningProfileParameter model) {
            certificateArn(model.certificateArn);
            platform(model.platform);
            certificatePathOnDevice(model.certificatePathOnDevice);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getCertificatePathOnDevice() {
            return certificatePathOnDevice;
        }

        public final void setCertificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
        }

        @Override
        public final Builder certificatePathOnDevice(String certificatePathOnDevice) {
            this.certificatePathOnDevice = certificatePathOnDevice;
            return this;
        }

        @Override
        public SigningProfileParameter build() {
            return new SigningProfileParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
