/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the ListPolicies operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesRequest extends IotRequest implements
        ToCopyableBuilder<ListPoliciesRequest.Builder, ListPoliciesRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(ListPoliciesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pageSize").getter(getter(ListPoliciesRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageSize").build()).build();

    private static final SdkField<Boolean> ASCENDING_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ascendingOrder").getter(getter(ListPoliciesRequest::ascendingOrder))
            .setter(setter(Builder::ascendingOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isAscendingOrder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, PAGE_SIZE_FIELD,
            ASCENDING_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final Integer pageSize;

    private final Boolean ascendingOrder;

    private ListPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
        this.ascendingOrder = builder.ascendingOrder;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The result page size.
     * </p>
     * 
     * @return The result page size.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * Specifies the order for results. If true, the results are returned in ascending creation order.
     * </p>
     * 
     * @return Specifies the order for results. If true, the results are returned in ascending creation order.
     */
    public final Boolean ascendingOrder() {
        return ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(ascendingOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesRequest)) {
            return false;
        }
        ListPoliciesRequest other = (ListPoliciesRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(ascendingOrder(), other.ascendingOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPoliciesRequest").add("Marker", marker()).add("PageSize", pageSize())
                .add("AscendingOrder", ascendingOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "pageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "ascendingOrder":
            return Optional.ofNullable(clazz.cast(ascendingOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("marker", MARKER_FIELD);
        map.put("pageSize", PAGE_SIZE_FIELD);
        map.put("isAscendingOrder", ASCENDING_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesRequest, T> g) {
        return obj -> g.apply((ListPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPoliciesRequest> {
        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The result page size.
         * </p>
         * 
         * @param pageSize
         *        The result page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * Specifies the order for results. If true, the results are returned in ascending creation order.
         * </p>
         * 
         * @param ascendingOrder
         *        Specifies the order for results. If true, the results are returned in ascending creation order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String marker;

        private Integer pageSize;

        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesRequest model) {
            super(model);
            marker(model.marker);
            pageSize(model.pageSize);
            ascendingOrder(model.ascendingOrder);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesRequest build() {
            return new ListPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
