/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends an input to an IoT Events detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotEventsAction implements SdkPojo, Serializable, ToCopyableBuilder<IotEventsAction.Builder, IotEventsAction> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(IotEventsAction::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(IotEventsAction::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("batchMode").getter(getter(IotEventsAction::batchMode)).setter(setter(Builder::batchMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(IotEventsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            MESSAGE_ID_FIELD, BATCH_MODE_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final String messageId;

    private final Boolean batchMode;

    private final String roleArn;

    private IotEventsAction(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.messageId = builder.messageId;
        this.batchMode = builder.batchMode;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the IoT Events input.
     * </p>
     * 
     * @return The name of the IoT Events input.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * The ID of the message. The default <code>messageId</code> is a new UUID value.
     * </p>
     * <p>
     * When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>--a new UUID value
     * will be assigned.
     * </p>
     * <p>
     * Assign a value to this property to ensure that only one input (message) with a given <code>messageId</code> will
     * be processed by an IoT Events detector.
     * </p>
     * 
     * @return The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
     *         <p>
     *         When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>--a new UUID
     *         value will be assigned.
     *         </p>
     *         <p>
     *         Assign a value to this property to ensure that only one input (message) with a given
     *         <code>messageId</code> will be processed by an IoT Events detector.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * Whether to process the event actions as a batch. The default value is <code>false</code>.
     * </p>
     * <p>
     * When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>.
     * </p>
     * <p>
     * When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array
     * element is treated as a separate message when it's sent to IoT Events by calling <a
     * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
     * <code>BatchPutMessage</code> </a>. The resulting array can't have more than 10 messages.
     * </p>
     * 
     * @return Whether to process the event actions as a batch. The default value is <code>false</code>.</p>
     *         <p>
     *         When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>.
     *         </p>
     *         <p>
     *         When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each
     *         Array element is treated as a separate message when it's sent to IoT Events by calling <a href=
     *         "https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
     *         <code>BatchPutMessage</code> </a>. The resulting array can't have more than 10 messages.
     */
    public final Boolean batchMode() {
        return batchMode;
    }

    /**
     * <p>
     * The ARN of the role that grants IoT permission to send an input to an IoT Events detector.
     * ("Action":"iotevents:BatchPutMessage").
     * </p>
     * 
     * @return The ARN of the role that grants IoT permission to send an input to an IoT Events detector.
     *         ("Action":"iotevents:BatchPutMessage").
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(batchMode());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotEventsAction)) {
            return false;
        }
        IotEventsAction other = (IotEventsAction) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(batchMode(), other.batchMode()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotEventsAction").add("InputName", inputName()).add("MessageId", messageId())
                .add("BatchMode", batchMode()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "batchMode":
            return Optional.ofNullable(clazz.cast(batchMode()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputName", INPUT_NAME_FIELD);
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("batchMode", BATCH_MODE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IotEventsAction, T> g) {
        return obj -> g.apply((IotEventsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotEventsAction> {
        /**
         * <p>
         * The name of the IoT Events input.
         * </p>
         * 
         * @param inputName
         *        The name of the IoT Events input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * The ID of the message. The default <code>messageId</code> is a new UUID value.
         * </p>
         * <p>
         * When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>--a new UUID
         * value will be assigned.
         * </p>
         * <p>
         * Assign a value to this property to ensure that only one input (message) with a given <code>messageId</code>
         * will be processed by an IoT Events detector.
         * </p>
         * 
         * @param messageId
         *        The ID of the message. The default <code>messageId</code> is a new UUID value.</p>
         *        <p>
         *        When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>--a new
         *        UUID value will be assigned.
         *        </p>
         *        <p>
         *        Assign a value to this property to ensure that only one input (message) with a given
         *        <code>messageId</code> will be processed by an IoT Events detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * Whether to process the event actions as a batch. The default value is <code>false</code>.
         * </p>
         * <p>
         * When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>.
         * </p>
         * <p>
         * When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array
         * element is treated as a separate message when it's sent to IoT Events by calling <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
         * <code>BatchPutMessage</code> </a>. The resulting array can't have more than 10 messages.
         * </p>
         * 
         * @param batchMode
         *        Whether to process the event actions as a batch. The default value is <code>false</code>.</p>
         *        <p>
         *        When <code>batchMode</code> is <code>true</code>, you can't specify a <code>messageId</code>.
         *        </p>
         *        <p>
         *        When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array,
         *        each Array element is treated as a separate message when it's sent to IoT Events by calling <a href=
         *        "https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html">
         *        <code>BatchPutMessage</code> </a>. The resulting array can't have more than 10 messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchMode(Boolean batchMode);

        /**
         * <p>
         * The ARN of the role that grants IoT permission to send an input to an IoT Events detector.
         * ("Action":"iotevents:BatchPutMessage").
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants IoT permission to send an input to an IoT Events detector.
         *        ("Action":"iotevents:BatchPutMessage").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private String messageId;

        private Boolean batchMode;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotEventsAction model) {
            inputName(model.inputName);
            messageId(model.messageId);
            batchMode(model.batchMode);
            roleArn(model.roleArn);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Boolean getBatchMode() {
            return batchMode;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public IotEventsAction build() {
            return new IotEventsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
