/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandExecutionResponse extends IotResponse implements
        ToCopyableBuilder<GetCommandExecutionResponse.Builder, GetCommandExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(GetCommandExecutionResponse::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(GetCommandExecutionResponse::commandArn)).setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(GetCommandExecutionResponse::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCommandExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusReason> STATUS_REASON_FIELD = SdkField.<StatusReason> builder(MarshallingType.SDK_POJO)
            .memberName("statusReason").getter(getter(GetCommandExecutionResponse::statusReason))
            .setter(setter(Builder::statusReason)).constructor(StatusReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Map<String, CommandExecutionResult>> RESULT_FIELD = SdkField
            .<Map<String, CommandExecutionResult>> builder(MarshallingType.MAP)
            .memberName("result")
            .getter(getter(GetCommandExecutionResponse::result))
            .setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CommandExecutionResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandExecutionResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CommandParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, CommandParameterValue>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(GetCommandExecutionResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CommandParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("executionTimeoutSeconds").getter(getter(GetCommandExecutionResponse::executionTimeoutSeconds))
            .setter(setter(Builder::executionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetCommandExecutionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(GetCommandExecutionResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(GetCommandExecutionResponse::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(GetCommandExecutionResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final SdkField<Instant> TIME_TO_LIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeToLive").getter(getter(GetCommandExecutionResponse::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            COMMAND_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RESULT_FIELD, PARAMETERS_FIELD,
            EXECUTION_TIMEOUT_SECONDS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD,
            TIME_TO_LIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionId;

    private final String commandArn;

    private final String targetArn;

    private final String status;

    private final StatusReason statusReason;

    private final Map<String, CommandExecutionResult> result;

    private final Map<String, CommandParameterValue> parameters;

    private final Long executionTimeoutSeconds;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Instant startedAt;

    private final Instant completedAt;

    private final Instant timeToLive;

    private GetCommandExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.commandArn = builder.commandArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.result = builder.result;
        this.parameters = builder.parameters;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.timeToLive = builder.timeToLive;
    }

    /**
     * <p>
     * The unique identifier of the command execution.
     * </p>
     * 
     * @return The unique identifier of the command execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the command. For example,
     * <code/>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the command. For example,
     *         <code/>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;
     */
    public final String commandArn() {
        return commandArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The status of the command execution. After your devices receive the command and start performing the operations
     * specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to update the status
     * information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command execution. After your devices receive the command and start performing the
     *         operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to
     *         update the status information.
     * @see CommandExecutionStatus
     */
    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the command execution. After your devices receive the command and start performing the operations
     * specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to update the status
     * information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command execution. After your devices receive the command and start performing the
     *         operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to
     *         update the status information.
     * @see CommandExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Your devices can use this parameter to provide additional context about the status of a command execution using a
     * reason code and description.
     * </p>
     * 
     * @return Your devices can use this parameter to provide additional context about the status of a command execution
     *         using a reason code and description.
     */
    public final StatusReason statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Result property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResult() {
        return result != null && !(result instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The result value for the current state of the command execution. The status provides information about the
     * progress of the command execution. The device can use the result field to share additional details about the
     * execution such as a return value of a remote function call.
     * </p>
     * <note>
     * <p>
     * If you use the <code>AWS-IoT-FleetWise</code> namespace, then this field is not applicable in the API response.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResult} method.
     * </p>
     * 
     * @return The result value for the current state of the command execution. The status provides information about
     *         the progress of the command execution. The device can use the result field to share additional details
     *         about the execution such as a return value of a remote function call.</p> <note>
     *         <p>
     *         If you use the <code>AWS-IoT-FleetWise</code> namespace, then this field is not applicable in the API
     *         response.
     *         </p>
     */
    public final Map<String, CommandExecutionResult> result() {
        return result;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of parameters that the <code>StartCommandExecution</code> API used when performing the command on the
     * device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The list of parameters that the <code>StartCommandExecution</code> API used when performing the command
     *         on the device.
     */
    public final Map<String, CommandParameterValue> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Specifies the amount of time in seconds that the device can take to finish a command execution. A timer starts
     * when the command execution is created. If the command execution status is not set to another terminal state
     * before the timer expires, it will automatically update to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time in seconds that the device can take to finish a command execution. A timer
     *         starts when the command execution is created. If the command execution status is not set to another
     *         terminal state before the timer expires, it will automatically update to <code>TIMED_OUT</code>.
     */
    public final Long executionTimeoutSeconds() {
        return executionTimeoutSeconds;
    }

    /**
     * <p>
     * The timestamp, when the command execution was created.
     * </p>
     * 
     * @return The timestamp, when the command execution was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp, when the command execution was last updated.
     * </p>
     * 
     * @return The timestamp, when the command execution was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The timestamp, when the command execution was started.
     * </p>
     * 
     * @return The timestamp, when the command execution was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The timestamp, when the command execution was completed.
     * </p>
     * 
     * @return The timestamp, when the command execution was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The time to live (TTL) parameter that indicates the duration for which executions will be retained in your
     * account. The default value is six months.
     * </p>
     * 
     * @return The time to live (TTL) parameter that indicates the duration for which executions will be retained in
     *         your account. The default value is six months.
     */
    public final Instant timeToLive() {
        return timeToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasResult() ? result() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandExecutionResponse)) {
            return false;
        }
        GetCommandExecutionResponse other = (GetCommandExecutionResponse) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(commandArn(), other.commandArn())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && hasResult() == other.hasResult()
                && Objects.equals(result(), other.result()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(executionTimeoutSeconds(), other.executionTimeoutSeconds())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(timeToLive(), other.timeToLive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommandExecutionResponse").add("ExecutionId", executionId()).add("CommandArn", commandArn())
                .add("TargetArn", targetArn()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("Result", hasResult() ? result() : null).add("Parameters", hasParameters() ? parameters() : null)
                .add("ExecutionTimeoutSeconds", executionTimeoutSeconds()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("StartedAt", startedAt()).add("CompletedAt", completedAt())
                .add("TimeToLive", timeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "executionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(executionTimeoutSeconds()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "timeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("timeToLive", TIME_TO_LIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandExecutionResponse, T> g) {
        return obj -> g.apply((GetCommandExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandExecutionResponse> {
        /**
         * <p>
         * The unique identifier of the command execution.
         * </p>
         * 
         * @param executionId
         *        The unique identifier of the command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the command. For example,
         * <code/>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Number (ARN) of the command. For example,
         *        <code/>arn:aws:iot:&lt;region&gt;:&lt;accountid&gt;:command/&lt;commandId&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Number (ARN) of the device on which the command execution is being performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The status of the command execution. After your devices receive the command and start performing the
         * operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to update
         * the status information.
         * </p>
         * 
         * @param status
         *        The status of the command execution. After your devices receive the command and start performing the
         *        operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to
         *        update the status information.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the command execution. After your devices receive the command and start performing the
         * operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to update
         * the status information.
         * </p>
         * 
         * @param status
         *        The status of the command execution. After your devices receive the command and start performing the
         *        operations specified in the command, it can use the <code>UpdateCommandExecution</code> MQTT API to
         *        update the status information.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(CommandExecutionStatus status);

        /**
         * <p>
         * Your devices can use this parameter to provide additional context about the status of a command execution
         * using a reason code and description.
         * </p>
         * 
         * @param statusReason
         *        Your devices can use this parameter to provide additional context about the status of a command
         *        execution using a reason code and description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(StatusReason statusReason);

        /**
         * <p>
         * Your devices can use this parameter to provide additional context about the status of a command execution
         * using a reason code and description.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusReason.Builder} avoiding the need
         * to create one manually via {@link StatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusReason.Builder#build()} is called immediately and its
         * result is passed to {@link #statusReason(StatusReason)}.
         * 
         * @param statusReason
         *        a consumer that will call methods on {@link StatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReason(StatusReason)
         */
        default Builder statusReason(Consumer<StatusReason.Builder> statusReason) {
            return statusReason(StatusReason.builder().applyMutation(statusReason).build());
        }

        /**
         * <p>
         * The result value for the current state of the command execution. The status provides information about the
         * progress of the command execution. The device can use the result field to share additional details about the
         * execution such as a return value of a remote function call.
         * </p>
         * <note>
         * <p>
         * If you use the <code>AWS-IoT-FleetWise</code> namespace, then this field is not applicable in the API
         * response.
         * </p>
         * </note>
         * 
         * @param result
         *        The result value for the current state of the command execution. The status provides information about
         *        the progress of the command execution. The device can use the result field to share additional details
         *        about the execution such as a return value of a remote function call.</p> <note>
         *        <p>
         *        If you use the <code>AWS-IoT-FleetWise</code> namespace, then this field is not applicable in the API
         *        response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Map<String, CommandExecutionResult> result);

        /**
         * <p>
         * The list of parameters that the <code>StartCommandExecution</code> API used when performing the command on
         * the device.
         * </p>
         * 
         * @param parameters
         *        The list of parameters that the <code>StartCommandExecution</code> API used when performing the
         *        command on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, CommandParameterValue> parameters);

        /**
         * <p>
         * Specifies the amount of time in seconds that the device can take to finish a command execution. A timer
         * starts when the command execution is created. If the command execution status is not set to another terminal
         * state before the timer expires, it will automatically update to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param executionTimeoutSeconds
         *        Specifies the amount of time in seconds that the device can take to finish a command execution. A
         *        timer starts when the command execution is created. If the command execution status is not set to
         *        another terminal state before the timer expires, it will automatically update to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeoutSeconds(Long executionTimeoutSeconds);

        /**
         * <p>
         * The timestamp, when the command execution was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp, when the command execution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp, when the command execution was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp, when the command execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The timestamp, when the command execution was started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp, when the command execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The timestamp, when the command execution was completed.
         * </p>
         * 
         * @param completedAt
         *        The timestamp, when the command execution was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * The time to live (TTL) parameter that indicates the duration for which executions will be retained in your
         * account. The default value is six months.
         * </p>
         * 
         * @param timeToLive
         *        The time to live (TTL) parameter that indicates the duration for which executions will be retained in
         *        your account. The default value is six months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Instant timeToLive);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String executionId;

        private String commandArn;

        private String targetArn;

        private String status;

        private StatusReason statusReason;

        private Map<String, CommandExecutionResult> result = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CommandParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Long executionTimeoutSeconds;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Instant startedAt;

        private Instant completedAt;

        private Instant timeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandExecutionResponse model) {
            super(model);
            executionId(model.executionId);
            commandArn(model.commandArn);
            targetArn(model.targetArn);
            status(model.status);
            statusReason(model.statusReason);
            result(model.result);
            parameters(model.parameters);
            executionTimeoutSeconds(model.executionTimeoutSeconds);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
            timeToLive(model.timeToLive);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusReason.Builder getStatusReason() {
            return statusReason != null ? statusReason.toBuilder() : null;
        }

        public final void setStatusReason(StatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(StatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, CommandExecutionResult.Builder> getResult() {
            Map<String, CommandExecutionResult.Builder> result = CommandExecutionResultMapCopier.copyToBuilder(this.result);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResult(Map<String, CommandExecutionResult.BuilderImpl> result) {
            this.result = CommandExecutionResultMapCopier.copyFromBuilder(result);
        }

        @Override
        public final Builder result(Map<String, CommandExecutionResult> result) {
            this.result = CommandExecutionResultMapCopier.copy(result);
            return this;
        }

        public final Map<String, CommandParameterValue.Builder> getParameters() {
            Map<String, CommandParameterValue.Builder> result = CommandExecutionParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, CommandParameterValue.BuilderImpl> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, CommandParameterValue> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Long getExecutionTimeoutSeconds() {
            return executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getTimeToLive() {
            return timeToLive;
        }

        public final void setTimeToLive(Instant timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Instant timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Override
        public GetCommandExecutionResponse build() {
            return new GetCommandExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
