/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that writes data to an Amazon Kinesis Firehose stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirehoseAction implements SdkPojo, Serializable, ToCopyableBuilder<FirehoseAction.Builder, FirehoseAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(FirehoseAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryStreamName").getter(getter(FirehoseAction::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStreamName").build())
            .build();

    private static final SdkField<String> SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("separator").getter(getter(FirehoseAction::separator)).setter(setter(Builder::separator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("separator").build()).build();

    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("batchMode").getter(getter(FirehoseAction::batchMode)).setter(setter(Builder::batchMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DELIVERY_STREAM_NAME_FIELD, SEPARATOR_FIELD, BATCH_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String deliveryStreamName;

    private final String separator;

    private final Boolean batchMode;

    private FirehoseAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
        this.batchMode = builder.batchMode;
    }

    /**
     * <p>
     * The IAM role that grants access to the Amazon Kinesis Firehose stream.
     * </p>
     * 
     * @return The IAM role that grants access to the Amazon Kinesis Firehose stream.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The delivery stream name.
     * </p>
     * 
     * @return The delivery stream name.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * A character separator that will be used to separate records written to the Firehose stream. Valid values are:
     * '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     * </p>
     * 
     * @return A character separator that will be used to separate records written to the Firehose stream. Valid values
     *         are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public final String separator() {
        return separator;
    }

    /**
     * <p>
     * Whether to deliver the Kinesis Data Firehose stream as a batch by using <a
     * href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
     * <code>PutRecordBatch</code> </a>. The default value is <code>false</code>.
     * </p>
     * <p>
     * When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each Array
     * element forms one record in the <a
     * href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
     * <code>PutRecordBatch</code> </a> request. The resulting array can't have more than 500 records.
     * </p>
     * 
     * @return Whether to deliver the Kinesis Data Firehose stream as a batch by using <a
     *         href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
     *         <code>PutRecordBatch</code> </a>. The default value is <code>false</code>.</p>
     *         <p>
     *         When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each
     *         Array element forms one record in the <a
     *         href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
     *         <code>PutRecordBatch</code> </a> request. The resulting array can't have more than 500 records.
     */
    public final Boolean batchMode() {
        return batchMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(separator());
        hashCode = 31 * hashCode + Objects.hashCode(batchMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(separator(), other.separator()) && Objects.equals(batchMode(), other.batchMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirehoseAction").add("RoleArn", roleArn()).add("DeliveryStreamName", deliveryStreamName())
                .add("Separator", separator()).add("BatchMode", batchMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "deliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "separator":
            return Optional.ofNullable(clazz.cast(separator()));
        case "batchMode":
            return Optional.ofNullable(clazz.cast(batchMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("deliveryStreamName", DELIVERY_STREAM_NAME_FIELD);
        map.put("separator", SEPARATOR_FIELD);
        map.put("batchMode", BATCH_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirehoseAction, T> g) {
        return obj -> g.apply((FirehoseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirehoseAction> {
        /**
         * <p>
         * The IAM role that grants access to the Amazon Kinesis Firehose stream.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants access to the Amazon Kinesis Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The delivery stream name.
         * </p>
         * 
         * @param deliveryStreamName
         *        The delivery stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * A character separator that will be used to separate records written to the Firehose stream. Valid values are:
         * '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * </p>
         * 
         * @param separator
         *        A character separator that will be used to separate records written to the Firehose stream. Valid
         *        values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separator(String separator);

        /**
         * <p>
         * Whether to deliver the Kinesis Data Firehose stream as a batch by using <a
         * href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
         * <code>PutRecordBatch</code> </a>. The default value is <code>false</code>.
         * </p>
         * <p>
         * When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each
         * Array element forms one record in the <a
         * href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
         * <code>PutRecordBatch</code> </a> request. The resulting array can't have more than 500 records.
         * </p>
         * 
         * @param batchMode
         *        Whether to deliver the Kinesis Data Firehose stream as a batch by using <a
         *        href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
         *        <code>PutRecordBatch</code> </a>. The default value is <code>false</code>.</p>
         *        <p>
         *        When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array,
         *        each Array element forms one record in the <a
         *        href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html">
         *        <code>PutRecordBatch</code> </a> request. The resulting array can't have more than 500 records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchMode(Boolean batchMode);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String deliveryStreamName;

        private String separator;

        private Boolean batchMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            roleArn(model.roleArn);
            deliveryStreamName(model.deliveryStreamName);
            separator(model.separator);
            batchMode(model.batchMode);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getSeparator() {
            return separator;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final Boolean getBatchMode() {
            return batchMode;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        @Override
        public FirehoseAction build() {
            return new FirehoseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
