/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCertificateProviderResponse extends IotResponse implements
        ToCopyableBuilder<DescribeCertificateProviderResponse.Builder, DescribeCertificateProviderResponse> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderName").getter(getter(DescribeCertificateProviderResponse::certificateProviderName))
            .setter(setter(Builder::certificateProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderName").build())
            .build();

    private static final SdkField<String> CERTIFICATE_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderArn").getter(getter(DescribeCertificateProviderResponse::certificateProviderArn))
            .setter(setter(Builder::certificateProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderArn").build())
            .build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaFunctionArn").getter(getter(DescribeCertificateProviderResponse::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()).build();

    private static final SdkField<List<String>> ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountDefaultForOperations")
            .getter(getter(DescribeCertificateProviderResponse::accountDefaultForOperationsAsStrings))
            .setter(setter(Builder::accountDefaultForOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDefaultForOperations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeCertificateProviderResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(DescribeCertificateProviderResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_PROVIDER_NAME_FIELD, CERTIFICATE_PROVIDER_ARN_FIELD, LAMBDA_FUNCTION_ARN_FIELD,
            ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateProviderName;

    private final String certificateProviderArn;

    private final String lambdaFunctionArn;

    private final List<String> accountDefaultForOperations;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeCertificateProviderResponse(BuilderImpl builder) {
        super(builder);
        this.certificateProviderName = builder.certificateProviderName;
        this.certificateProviderArn = builder.certificateProviderArn;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.accountDefaultForOperations = builder.accountDefaultForOperations;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The name of the certificate provider.
     * </p>
     * 
     * @return The name of the certificate provider.
     */
    public final String certificateProviderName() {
        return certificateProviderName;
    }

    /**
     * <p>
     * The ARN of the certificate provider.
     * </p>
     * 
     * @return The ARN of the certificate provider.
     */
    public final String certificateProviderArn() {
        return certificateProviderArn;
    }

    /**
     * <p>
     * The Lambda function ARN that's associated with the certificate provider.
     * </p>
     * 
     * @return The Lambda function ARN that's associated with the certificate provider.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    /**
     * <p>
     * A list of the operations that the certificate provider will use to generate certificates. Valid value:
     * <code>CreateCertificateFromCsr</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountDefaultForOperations} method.
     * </p>
     * 
     * @return A list of the operations that the certificate provider will use to generate certificates. Valid value:
     *         <code>CreateCertificateFromCsr</code>.
     */
    public final List<CertificateProviderOperation> accountDefaultForOperations() {
        return CertificateProviderAccountDefaultForOperationsCopier.copyStringToEnum(accountDefaultForOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountDefaultForOperations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountDefaultForOperations() {
        return accountDefaultForOperations != null && !(accountDefaultForOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the operations that the certificate provider will use to generate certificates. Valid value:
     * <code>CreateCertificateFromCsr</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountDefaultForOperations} method.
     * </p>
     * 
     * @return A list of the operations that the certificate provider will use to generate certificates. Valid value:
     *         <code>CreateCertificateFromCsr</code>.
     */
    public final List<String> accountDefaultForOperationsAsStrings() {
        return accountDefaultForOperations;
    }

    /**
     * <p>
     * The date-time string that indicates when the certificate provider was created.
     * </p>
     * 
     * @return The date-time string that indicates when the certificate provider was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date-time string that indicates when the certificate provider was last updated.
     * </p>
     * 
     * @return The date-time string that indicates when the certificate provider was last updated.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAccountDefaultForOperations() ? accountDefaultForOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateProviderResponse)) {
            return false;
        }
        DescribeCertificateProviderResponse other = (DescribeCertificateProviderResponse) obj;
        return Objects.equals(certificateProviderName(), other.certificateProviderName())
                && Objects.equals(certificateProviderArn(), other.certificateProviderArn())
                && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn())
                && hasAccountDefaultForOperations() == other.hasAccountDefaultForOperations()
                && Objects.equals(accountDefaultForOperationsAsStrings(), other.accountDefaultForOperationsAsStrings())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeCertificateProviderResponse")
                .add("CertificateProviderName", certificateProviderName())
                .add("CertificateProviderArn", certificateProviderArn())
                .add("LambdaFunctionArn", lambdaFunctionArn())
                .add("AccountDefaultForOperations",
                        hasAccountDefaultForOperations() ? accountDefaultForOperationsAsStrings() : null)
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateProviderName":
            return Optional.ofNullable(clazz.cast(certificateProviderName()));
        case "certificateProviderArn":
            return Optional.ofNullable(clazz.cast(certificateProviderArn()));
        case "lambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        case "accountDefaultForOperations":
            return Optional.ofNullable(clazz.cast(accountDefaultForOperationsAsStrings()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateProviderName", CERTIFICATE_PROVIDER_NAME_FIELD);
        map.put("certificateProviderArn", CERTIFICATE_PROVIDER_ARN_FIELD);
        map.put("lambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        map.put("accountDefaultForOperations", ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCertificateProviderResponse, T> g) {
        return obj -> g.apply((DescribeCertificateProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCertificateProviderResponse> {
        /**
         * <p>
         * The name of the certificate provider.
         * </p>
         * 
         * @param certificateProviderName
         *        The name of the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateProviderName(String certificateProviderName);

        /**
         * <p>
         * The ARN of the certificate provider.
         * </p>
         * 
         * @param certificateProviderArn
         *        The ARN of the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateProviderArn(String certificateProviderArn);

        /**
         * <p>
         * The Lambda function ARN that's associated with the certificate provider.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        The Lambda function ARN that's associated with the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperationsWithStrings(String... accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperations(CertificateProviderOperation... accountDefaultForOperations);

        /**
         * <p>
         * The date-time string that indicates when the certificate provider was created.
         * </p>
         * 
         * @param creationDate
         *        The date-time string that indicates when the certificate provider was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date-time string that indicates when the certificate provider was last updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date-time string that indicates when the certificate provider was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String certificateProviderName;

        private String certificateProviderArn;

        private String lambdaFunctionArn;

        private List<String> accountDefaultForOperations = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateProviderResponse model) {
            super(model);
            certificateProviderName(model.certificateProviderName);
            certificateProviderArn(model.certificateProviderArn);
            lambdaFunctionArn(model.lambdaFunctionArn);
            accountDefaultForOperationsWithStrings(model.accountDefaultForOperations);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getCertificateProviderName() {
            return certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getCertificateProviderArn() {
            return certificateProviderArn;
        }

        public final void setCertificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
        }

        @Override
        public final Builder certificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getAccountDefaultForOperations() {
            if (accountDefaultForOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return accountDefaultForOperations;
        }

        public final void setAccountDefaultForOperations(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copy(accountDefaultForOperations);
        }

        @Override
        public final Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copy(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperationsWithStrings(String... accountDefaultForOperations) {
            accountDefaultForOperationsWithStrings(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public final Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copyEnumToString(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperations(CertificateProviderOperation... accountDefaultForOperations) {
            accountDefaultForOperations(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public DescribeCertificateProviderResponse build() {
            return new DescribeCertificateProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
