/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCommandResponse extends IotResponse implements
        ToCopyableBuilder<DeleteCommandResponse.Builder, DeleteCommandResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statusCode").getter(getter(DeleteCommandResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer statusCodeValue;

    private DeleteCommandResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
    }

    /**
     * <p>
     * The status code for the command deletion request. The status code is in the 200 range for a successful request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the command hasn't been deprecated, or has been deprecated for a duration that is shorter than the maximum
     * time out duration of 12 hours, when calling the <code>DeleteCommand</code> request, the deletion will be
     * scheduled and a 202 status code will be returned. While the command is being deleted, it will be in a
     * <code>pendingDeletion</code> state. Once the time out duration has been reached, the command will be permanently
     * removed from your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the command has been deprecated for a duration that is longer than the maximum time out duration of 12 hours,
     * when calling the <code>DeleteCommand</code> request, the command will be deleted immediately and a 204 status
     * code will be returned.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status code for the command deletion request. The status code is in the 200 range for a successful
     *         request.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the command hasn't been deprecated, or has been deprecated for a duration that is shorter than the
     *         maximum time out duration of 12 hours, when calling the <code>DeleteCommand</code> request, the deletion
     *         will be scheduled and a 202 status code will be returned. While the command is being deleted, it will be
     *         in a <code>pendingDeletion</code> state. Once the time out duration has been reached, the command will be
     *         permanently removed from your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the command has been deprecated for a duration that is longer than the maximum time out duration of 12
     *         hours, when calling the <code>DeleteCommand</code> request, the command will be deleted immediately and a
     *         204 status code will be returned.
     *         </p>
     *         </li>
     */
    public final Integer statusCode() {
        return statusCodeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCommandResponse)) {
            return false;
        }
        DeleteCommandResponse other = (DeleteCommandResponse) obj;
        return Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCommandResponse").add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCommandResponse, T> g) {
        return obj -> g.apply((DeleteCommandResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCommandResponse> {
        /**
         * <p>
         * The status code for the command deletion request. The status code is in the 200 range for a successful
         * request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the command hasn't been deprecated, or has been deprecated for a duration that is shorter than the maximum
         * time out duration of 12 hours, when calling the <code>DeleteCommand</code> request, the deletion will be
         * scheduled and a 202 status code will be returned. While the command is being deleted, it will be in a
         * <code>pendingDeletion</code> state. Once the time out duration has been reached, the command will be
         * permanently removed from your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the command has been deprecated for a duration that is longer than the maximum time out duration of 12
         * hours, when calling the <code>DeleteCommand</code> request, the command will be deleted immediately and a 204
         * status code will be returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusCodeValue
         *        The status code for the command deletion request. The status code is in the 200 range for a successful
         *        request.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the command hasn't been deprecated, or has been deprecated for a duration that is shorter than the
         *        maximum time out duration of 12 hours, when calling the <code>DeleteCommand</code> request, the
         *        deletion will be scheduled and a 202 status code will be returned. While the command is being deleted,
         *        it will be in a <code>pendingDeletion</code> state. Once the time out duration has been reached, the
         *        command will be permanently removed from your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the command has been deprecated for a duration that is longer than the maximum time out duration of
         *        12 hours, when calling the <code>DeleteCommand</code> request, the command will be deleted immediately
         *        and a 204 status code will be returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCodeValue);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Integer statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCommandResponse model) {
            super(model);
            statusCode(model.statusCodeValue);
        }

        public final Integer getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public DeleteCommandResponse build() {
            return new DeleteCommandResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
