/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingTypeRequest extends IotRequest implements
        ToCopyableBuilder<CreateThingTypeRequest.Builder, CreateThingTypeRequest> {
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(CreateThingTypeRequest::thingTypeName))
            .setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingTypeName").build()).build();

    private static final SdkField<ThingTypeProperties> THING_TYPE_PROPERTIES_FIELD = SdkField
            .<ThingTypeProperties> builder(MarshallingType.SDK_POJO).memberName("thingTypeProperties")
            .getter(getter(CreateThingTypeRequest::thingTypeProperties)).setter(setter(Builder::thingTypeProperties))
            .constructor(ThingTypeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateThingTypeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_NAME_FIELD,
            THING_TYPE_PROPERTIES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingTypeName;

    private final ThingTypeProperties thingTypeProperties;

    private final List<Tag> tags;

    private CreateThingTypeRequest(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The ThingTypeProperties for the thing type to create. It contains information about the new thing type including
     * a description, and a list of searchable thing attribute names.
     * </p>
     * 
     * @return The ThingTypeProperties for the thing type to create. It contains information about the new thing type
     *         including a description, and a list of searchable thing attribute names.
     */
    public final ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the thing type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the thing type.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeRequest)) {
            return false;
        }
        CreateThingTypeRequest other = (CreateThingTypeRequest) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingTypeProperties(), other.thingTypeProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThingTypeRequest").add("ThingTypeName", thingTypeName())
                .add("ThingTypeProperties", thingTypeProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingTypeProperties":
            return Optional.ofNullable(clazz.cast(thingTypeProperties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingTypeName", THING_TYPE_NAME_FIELD);
        map.put("thingTypeProperties", THING_TYPE_PROPERTIES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateThingTypeRequest, T> g) {
        return obj -> g.apply((CreateThingTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingTypeRequest> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         * including a description, and a list of searchable thing attribute names.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         *        including a description, and a list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);

        /**
         * <p>
         * The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         * including a description, and a list of searchable thing attribute names.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThingTypeProperties.Builder} avoiding the
         * need to create one manually via {@link ThingTypeProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThingTypeProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingTypeProperties(ThingTypeProperties)}.
         * 
         * @param thingTypeProperties
         *        a consumer that will call methods on {@link ThingTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeProperties(ThingTypeProperties)
         */
        default Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return thingTypeProperties(ThingTypeProperties.builder().applyMutation(thingTypeProperties).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the thing type.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the thing type.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the thing type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingTypeName;

        private ThingTypeProperties thingTypeProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeRequest model) {
            super(model);
            thingTypeName(model.thingTypeName);
            thingTypeProperties(model.thingTypeProperties);
            tags(model.tags);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return thingTypeProperties != null ? thingTypeProperties.toBuilder() : null;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingTypeRequest build() {
            return new CreateThingTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
