/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageResponse extends IotResponse implements
        ToCopyableBuilder<CreatePackageResponse.Builder, CreatePackageResponse> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(CreatePackageResponse::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageArn").getter(getter(CreatePackageResponse::packageArn)).setter(setter(Builder::packageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePackageResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            PACKAGE_ARN_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String packageArn;

    private final String description;

    private CreatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageArn = builder.packageArn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the software package.
     * </p>
     * 
     * @return The name of the software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the package.
     */
    public final String packageArn() {
        return packageArn;
    }

    /**
     * <p>
     * The package description.
     * </p>
     * 
     * @return The package description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageResponse)) {
            return false;
        }
        CreatePackageResponse other = (CreatePackageResponse) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(packageArn(), other.packageArn())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageResponse").add("PackageName", packageName()).add("PackageArn", packageArn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "packageArn":
            return Optional.ofNullable(clazz.cast(packageArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("packageArn", PACKAGE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageResponse, T> g) {
        return obj -> g.apply((CreatePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageResponse> {
        /**
         * <p>
         * The name of the software package.
         * </p>
         * 
         * @param packageName
         *        The name of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the package.
         * </p>
         * 
         * @param packageArn
         *        The Amazon Resource Name (ARN) for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageArn(String packageArn);

        /**
         * <p>
         * The package description.
         * </p>
         * 
         * @param description
         *        The package description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String packageName;

        private String packageArn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageResponse model) {
            super(model);
            packageName(model.packageName);
            packageArn(model.packageArn);
            description(model.description);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageArn() {
            return packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public CreatePackageResponse build() {
            return new CreatePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
