/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a particular command execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CommandExecutionSummary.Builder, CommandExecutionSummary> {
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commandArn").getter(getter(CommandExecutionSummary::commandArn)).setter(setter(Builder::commandArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(CommandExecutionSummary::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(CommandExecutionSummary::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CommandExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CommandExecutionSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(CommandExecutionSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(CommandExecutionSummary::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ARN_FIELD,
            EXECUTION_ID_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commandArn;

    private final String executionId;

    private final String targetArn;

    private final String status;

    private final Instant createdAt;

    private final Instant startedAt;

    private final Instant completedAt;

    private CommandExecutionSummary(BuilderImpl builder) {
        this.commandArn = builder.commandArn;
        this.executionId = builder.executionId;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the command execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the command execution.
     */
    public final String commandArn() {
        return commandArn;
    }

    /**
     * <p>
     * The unique identifier of the command execution.
     * </p>
     * 
     * @return The unique identifier of the command execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target device for which the command is being executed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target device for which the command is being executed.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The status of the command executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command executions.
     * @see CommandExecutionStatus
     */
    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the command executions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command executions.
     * @see CommandExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time at which the command execution was created for the target device.
     * </p>
     * 
     * @return The date and time at which the command execution was created for the target device.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time at which the command started executing on the target device.
     * </p>
     * 
     * @return The date and time at which the command started executing on the target device.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time at which the command completed executing on the target device.
     * </p>
     * 
     * @return The date and time at which the command completed executing on the target device.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecutionSummary)) {
            return false;
        }
        CommandExecutionSummary other = (CommandExecutionSummary) obj;
        return Objects.equals(commandArn(), other.commandArn()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(completedAt(), other.completedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandExecutionSummary").add("CommandArn", commandArn()).add("ExecutionId", executionId())
                .add("TargetArn", targetArn()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .add("StartedAt", startedAt()).add("CompletedAt", completedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandArn":
            return Optional.ofNullable(clazz.cast(commandArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandExecutionSummary, T> g) {
        return obj -> g.apply((CommandExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandExecutionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the command execution.
         * </p>
         * 
         * @param commandArn
         *        The Amazon Resource Name (ARN) of the command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandArn(String commandArn);

        /**
         * <p>
         * The unique identifier of the command execution.
         * </p>
         * 
         * @param executionId
         *        The unique identifier of the command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target device for which the command is being executed.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the target device for which the command is being executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The status of the command executions.
         * </p>
         * 
         * @param status
         *        The status of the command executions.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the command executions.
         * </p>
         * 
         * @param status
         *        The status of the command executions.
         * @see CommandExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandExecutionStatus
         */
        Builder status(CommandExecutionStatus status);

        /**
         * <p>
         * The date and time at which the command execution was created for the target device.
         * </p>
         * 
         * @param createdAt
         *        The date and time at which the command execution was created for the target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time at which the command started executing on the target device.
         * </p>
         * 
         * @param startedAt
         *        The date and time at which the command started executing on the target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time at which the command completed executing on the target device.
         * </p>
         * 
         * @param completedAt
         *        The date and time at which the command completed executing on the target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);
    }

    static final class BuilderImpl implements Builder {
        private String commandArn;

        private String executionId;

        private String targetArn;

        private String status;

        private Instant createdAt;

        private Instant startedAt;

        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecutionSummary model) {
            commandArn(model.commandArn);
            executionId(model.executionId);
            targetArn(model.targetArn);
            status(model.status);
            createdAt(model.createdAt);
            startedAt(model.startedAt);
            completedAt(model.completedAt);
        }

        public final String getCommandArn() {
            return commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public CommandExecutionSummary build() {
            return new CommandExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
