/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result value of the command execution. The device can use the result field to share additional details about the
 * execution such as a return value of a remote function call.
 * </p>
 * <note>
 * <p>
 * This field is not applicable if you use the <code>AWS-IoT-FleetWise</code> namespace.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandExecutionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CommandExecutionResult.Builder, CommandExecutionResult> {
    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S")
            .getter(getter(CommandExecutionResult::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<Boolean> B_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("B")
            .getter(getter(CommandExecutionResult::b)).setter(setter(Builder::b))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()).build();

    private static final SdkField<SdkBytes> BIN_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES).memberName("BIN")
            .getter(getter(CommandExecutionResult::bin)).setter(setter(Builder::bin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BIN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, B_FIELD, BIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s;

    private final Boolean b;

    private final SdkBytes bin;

    private CommandExecutionResult(BuilderImpl builder) {
        this.s = builder.s;
        this.b = builder.b;
        this.bin = builder.bin;
    }

    /**
     * <p>
     * An attribute of type String. For example:
     * </p>
     * <p>
     * <code>"S": "Hello"</code>
     * </p>
     * 
     * @return An attribute of type String. For example:</p>
     *         <p>
     *         <code>"S": "Hello"</code>
     */
    public final String s() {
        return s;
    }

    /**
     * <p>
     * An attribute of type Boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @return An attribute of type Boolean. For example:</p>
     *         <p>
     *         <code>"BOOL": true</code>
     */
    public final Boolean b() {
        return b;
    }

    /**
     * <p>
     * An attribute of type Binary.
     * </p>
     * 
     * @return An attribute of type Binary.
     */
    public final SdkBytes bin() {
        return bin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(b());
        hashCode = 31 * hashCode + Objects.hashCode(bin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecutionResult)) {
            return false;
        }
        CommandExecutionResult other = (CommandExecutionResult) obj;
        return Objects.equals(s(), other.s()) && Objects.equals(b(), other.b()) && Objects.equals(bin(), other.bin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandExecutionResult").add("S", s()).add("B", b()).add("BIN", bin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "B":
            return Optional.ofNullable(clazz.cast(b()));
        case "BIN":
            return Optional.ofNullable(clazz.cast(bin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S", S_FIELD);
        map.put("B", B_FIELD);
        map.put("BIN", BIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandExecutionResult, T> g) {
        return obj -> g.apply((CommandExecutionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandExecutionResult> {
        /**
         * <p>
         * An attribute of type String. For example:
         * </p>
         * <p>
         * <code>"S": "Hello"</code>
         * </p>
         * 
         * @param s
         *        An attribute of type String. For example:</p>
         *        <p>
         *        <code>"S": "Hello"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * An attribute of type Boolean. For example:
         * </p>
         * <p>
         * <code>"BOOL": true</code>
         * </p>
         * 
         * @param b
         *        An attribute of type Boolean. For example:</p>
         *        <p>
         *        <code>"BOOL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder b(Boolean b);

        /**
         * <p>
         * An attribute of type Binary.
         * </p>
         * 
         * @param bin
         *        An attribute of type Binary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bin(SdkBytes bin);
    }

    static final class BuilderImpl implements Builder {
        private String s;

        private Boolean b;

        private SdkBytes bin;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecutionResult model) {
            s(model.s);
            b(model.b);
            bin(model.bin);
        }

        public final String getS() {
            return s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final Boolean getB() {
            return b;
        }

        public final void setB(Boolean b) {
            this.b = b;
        }

        @Override
        public final Builder b(Boolean b) {
            this.b = b;
            return this;
        }

        public final ByteBuffer getBin() {
            return bin == null ? null : bin.asByteBuffer();
        }

        public final void setBin(ByteBuffer bin) {
            bin(bin == null ? null : SdkBytes.fromByteBuffer(bin));
        }

        @Override
        public final Builder bin(SdkBytes bin) {
            this.bin = bin;
            return this;
        }

        @Override
        public CommandExecutionResult build() {
            return new CommandExecutionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
