/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSbomWithPackageVersionRequest extends IotRequest implements
        ToCopyableBuilder<AssociateSbomWithPackageVersionRequest.Builder, AssociateSbomWithPackageVersionRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(AssociateSbomWithPackageVersionRequest::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AssociateSbomWithPackageVersionRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()).build();

    private static final SdkField<Sbom> SBOM_FIELD = SdkField.<Sbom> builder(MarshallingType.SDK_POJO).memberName("sbom")
            .getter(getter(AssociateSbomWithPackageVersionRequest::sbom)).setter(setter(Builder::sbom))
            .constructor(Sbom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(AssociateSbomWithPackageVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            VERSION_NAME_FIELD, SBOM_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String versionName;

    private final Sbom sbom;

    private final String clientToken;

    private AssociateSbomWithPackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.sbom = builder.sbom;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the new software package.
     * </p>
     * 
     * @return The name of the new software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The name of the new package version.
     * </p>
     * 
     * @return The name of the new package version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * Returns the value of the Sbom property for this object.
     * 
     * @return The value of the Sbom property for this object.
     */
    public final Sbom sbom() {
        return sbom;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(sbom());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSbomWithPackageVersionRequest)) {
            return false;
        }
        AssociateSbomWithPackageVersionRequest other = (AssociateSbomWithPackageVersionRequest) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(sbom(), other.sbom()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSbomWithPackageVersionRequest").add("PackageName", packageName())
                .add("VersionName", versionName()).add("Sbom", sbom()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "sbom":
            return Optional.ofNullable(clazz.cast(sbom()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("sbom", SBOM_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSbomWithPackageVersionRequest, T> g) {
        return obj -> g.apply((AssociateSbomWithPackageVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSbomWithPackageVersionRequest> {
        /**
         * <p>
         * The name of the new software package.
         * </p>
         * 
         * @param packageName
         *        The name of the new software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The name of the new package version.
         * </p>
         * 
         * @param versionName
         *        The name of the new package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * Sets the value of the Sbom property for this object.
         *
         * @param sbom
         *        The new value for the Sbom property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sbom(Sbom sbom);

        /**
         * Sets the value of the Sbom property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Sbom.Builder} avoiding the need to create
         * one manually via {@link Sbom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sbom.Builder#build()} is called immediately and its result is
         * passed to {@link #sbom(Sbom)}.
         * 
         * @param sbom
         *        a consumer that will call methods on {@link Sbom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sbom(Sbom)
         */
        default Builder sbom(Consumer<Sbom.Builder> sbom) {
            return sbom(Sbom.builder().applyMutation(sbom).build());
        }

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String packageName;

        private String versionName;

        private Sbom sbom;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSbomWithPackageVersionRequest model) {
            super(model);
            packageName(model.packageName);
            versionName(model.versionName);
            sbom(model.sbom);
            clientToken(model.clientToken);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return sbom != null ? sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSbomWithPackageVersionRequest build() {
            return new AssociateSbomWithPackageVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
