/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters used when defining a mitigation action that move a set of things to a thing group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddThingsToThingGroupParams implements SdkPojo, Serializable,
        ToCopyableBuilder<AddThingsToThingGroupParams.Builder, AddThingsToThingGroupParams> {
    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("thingGroupNames")
            .getter(getter(AddThingsToThingGroupParams::thingGroupNames))
            .setter(setter(Builder::thingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overrideDynamicGroups").getter(getter(AddThingsToThingGroupParams::overrideDynamicGroups))
            .setter(setter(Builder::overrideDynamicGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAMES_FIELD,
            OVERRIDE_DYNAMIC_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> thingGroupNames;

    private final Boolean overrideDynamicGroups;

    private AddThingsToThingGroupParams(BuilderImpl builder) {
        this.thingGroupNames = builder.thingGroupNames;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingGroupNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThingGroupNames() {
        return thingGroupNames != null && !(thingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing
     * to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingGroupNames} method.
     * </p>
     * 
     * @return The list of groups to which you want to add the things that triggered the mitigation action. You can add
     *         a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
     *         hierarchy.
     */
    public final List<String> thingGroupNames() {
        return thingGroupNames;
    }

    /**
     * <p>
     * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are
     * part of one or more dynamic thing groups.
     * </p>
     * 
     * @return Specifies if this mitigation action can move the things that triggered the mitigation action even if they
     *         are part of one or more dynamic thing groups.
     */
    public final Boolean overrideDynamicGroups() {
        return overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroupNames() ? thingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overrideDynamicGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddThingsToThingGroupParams)) {
            return false;
        }
        AddThingsToThingGroupParams other = (AddThingsToThingGroupParams) obj;
        return hasThingGroupNames() == other.hasThingGroupNames() && Objects.equals(thingGroupNames(), other.thingGroupNames())
                && Objects.equals(overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddThingsToThingGroupParams")
                .add("ThingGroupNames", hasThingGroupNames() ? thingGroupNames() : null)
                .add("OverrideDynamicGroups", overrideDynamicGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupNames":
            return Optional.ofNullable(clazz.cast(thingGroupNames()));
        case "overrideDynamicGroups":
            return Optional.ofNullable(clazz.cast(overrideDynamicGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingGroupNames", THING_GROUP_NAMES_FIELD);
        map.put("overrideDynamicGroups", OVERRIDE_DYNAMIC_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddThingsToThingGroupParams, T> g) {
        return obj -> g.apply((AddThingsToThingGroupParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddThingsToThingGroupParams> {
        /**
         * <p>
         * The list of groups to which you want to add the things that triggered the mitigation action. You can add a
         * thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         * </p>
         * 
         * @param thingGroupNames
         *        The list of groups to which you want to add the things that triggered the mitigation action. You can
         *        add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
         *        hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(Collection<String> thingGroupNames);

        /**
         * <p>
         * The list of groups to which you want to add the things that triggered the mitigation action. You can add a
         * thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         * </p>
         * 
         * @param thingGroupNames
         *        The list of groups to which you want to add the things that triggered the mitigation action. You can
         *        add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same
         *        hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(String... thingGroupNames);

        /**
         * <p>
         * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are
         * part of one or more dynamic thing groups.
         * </p>
         * 
         * @param overrideDynamicGroups
         *        Specifies if this mitigation action can move the things that triggered the mitigation action even if
         *        they are part of one or more dynamic thing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideDynamicGroups(Boolean overrideDynamicGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(AddThingsToThingGroupParams model) {
            thingGroupNames(model.thingGroupNames);
            overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final Collection<String> getThingGroupNames() {
            if (thingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroupNames;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNamesCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String... thingGroupNames) {
            thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final Boolean getOverrideDynamicGroups() {
            return overrideDynamicGroups;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        @Override
        public AddThingsToThingGroupParams build() {
            return new AddThingsToThingGroupParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
