/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.SbomValidationResultSummary;
import software.amazon.awssdk.services.iot.model.SbomValidationResultSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSbomValidationResultsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListSbomValidationResultsResponse> {
    private static final SdkField<List<SbomValidationResultSummary>> VALIDATION_RESULT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationResultSummaries").getter(ListSbomValidationResultsResponse.getter(ListSbomValidationResultsResponse::validationResultSummaries)).setter(ListSbomValidationResultsResponse.setter(Builder::validationResultSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationResultSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SbomValidationResultSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSbomValidationResultsResponse.getter(ListSbomValidationResultsResponse::nextToken)).setter(ListSbomValidationResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_RESULT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSbomValidationResultsResponse.memberNameToFieldInitializer();
    private final List<SbomValidationResultSummary> validationResultSummaries;
    private final String nextToken;

    private ListSbomValidationResultsResponse(BuilderImpl builder) {
        super(builder);
        this.validationResultSummaries = builder.validationResultSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasValidationResultSummaries() {
        return this.validationResultSummaries != null && !(this.validationResultSummaries instanceof SdkAutoConstructList);
    }

    public final List<SbomValidationResultSummary> validationResultSummaries() {
        return this.validationResultSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationResultSummaries() ? this.validationResultSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSbomValidationResultsResponse)) {
            return false;
        }
        ListSbomValidationResultsResponse other = (ListSbomValidationResultsResponse)((Object)obj);
        return this.hasValidationResultSummaries() == other.hasValidationResultSummaries() && Objects.equals(this.validationResultSummaries(), other.validationResultSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSbomValidationResultsResponse").add("ValidationResultSummaries", this.hasValidationResultSummaries() ? this.validationResultSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationResultSummaries": {
                return Optional.ofNullable(clazz.cast(this.validationResultSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validationResultSummaries", VALIDATION_RESULT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSbomValidationResultsResponse, T> g) {
        return obj -> g.apply((ListSbomValidationResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<SbomValidationResultSummary> validationResultSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSbomValidationResultsResponse model) {
            super(model);
            this.validationResultSummaries(model.validationResultSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<SbomValidationResultSummary.Builder> getValidationResultSummaries() {
            List<SbomValidationResultSummary.Builder> result = SbomValidationResultSummaryListCopier.copyToBuilder(this.validationResultSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationResultSummaries(Collection<SbomValidationResultSummary.BuilderImpl> validationResultSummaries) {
            this.validationResultSummaries = SbomValidationResultSummaryListCopier.copyFromBuilder(validationResultSummaries);
        }

        @Override
        public final Builder validationResultSummaries(Collection<SbomValidationResultSummary> validationResultSummaries) {
            this.validationResultSummaries = SbomValidationResultSummaryListCopier.copy(validationResultSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationResultSummaries(SbomValidationResultSummary ... validationResultSummaries) {
            this.validationResultSummaries(Arrays.asList(validationResultSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationResultSummaries(Consumer<SbomValidationResultSummary.Builder> ... validationResultSummaries) {
            this.validationResultSummaries(Stream.of(validationResultSummaries).map(c -> (SbomValidationResultSummary)((SbomValidationResultSummary.Builder)SbomValidationResultSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSbomValidationResultsResponse build() {
            return new ListSbomValidationResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSbomValidationResultsResponse> {
        public Builder validationResultSummaries(Collection<SbomValidationResultSummary> var1);

        public Builder validationResultSummaries(SbomValidationResultSummary ... var1);

        public Builder validationResultSummaries(Consumer<SbomValidationResultSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

