/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.RelatedResource;
import software.amazon.awssdk.services.iot.model.RelatedResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRelatedResourcesForAuditFindingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListRelatedResourcesForAuditFindingResponse> {
    private static final SdkField<List<RelatedResource>> RELATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedResources").getter(ListRelatedResourcesForAuditFindingResponse.getter(ListRelatedResourcesForAuditFindingResponse::relatedResources)).setter(ListRelatedResourcesForAuditFindingResponse.setter(Builder::relatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRelatedResourcesForAuditFindingResponse.getter(ListRelatedResourcesForAuditFindingResponse::nextToken)).setter(ListRelatedResourcesForAuditFindingResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRelatedResourcesForAuditFindingResponse.memberNameToFieldInitializer();
    private final List<RelatedResource> relatedResources;
    private final String nextToken;

    private ListRelatedResourcesForAuditFindingResponse(BuilderImpl builder) {
        super(builder);
        this.relatedResources = builder.relatedResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRelatedResources() {
        return this.relatedResources != null && !(this.relatedResources instanceof SdkAutoConstructList);
    }

    public final List<RelatedResource> relatedResources() {
        return this.relatedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedResources() ? this.relatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelatedResourcesForAuditFindingResponse)) {
            return false;
        }
        ListRelatedResourcesForAuditFindingResponse other = (ListRelatedResourcesForAuditFindingResponse)((Object)obj);
        return this.hasRelatedResources() == other.hasRelatedResources() && Objects.equals(this.relatedResources(), other.relatedResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRelatedResourcesForAuditFindingResponse").add("RelatedResources", this.hasRelatedResources() ? this.relatedResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relatedResources": {
                return Optional.ofNullable(clazz.cast(this.relatedResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relatedResources", RELATED_RESOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRelatedResourcesForAuditFindingResponse, T> g) {
        return obj -> g.apply((ListRelatedResourcesForAuditFindingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<RelatedResource> relatedResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelatedResourcesForAuditFindingResponse model) {
            super(model);
            this.relatedResources(model.relatedResources);
            this.nextToken(model.nextToken);
        }

        public final List<RelatedResource.Builder> getRelatedResources() {
            List<RelatedResource.Builder> result = RelatedResourcesCopier.copyToBuilder(this.relatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedResources(Collection<RelatedResource.BuilderImpl> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public final Builder relatedResources(Collection<RelatedResource> relatedResources) {
            this.relatedResources = RelatedResourcesCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(RelatedResource ... relatedResources) {
            this.relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<RelatedResource.Builder> ... relatedResources) {
            this.relatedResources(Stream.of(relatedResources).map(c -> (RelatedResource)((RelatedResource.Builder)RelatedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRelatedResourcesForAuditFindingResponse build() {
            return new ListRelatedResourcesForAuditFindingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRelatedResourcesForAuditFindingResponse> {
        public Builder relatedResources(Collection<RelatedResource> var1);

        public Builder relatedResources(RelatedResource ... var1);

        public Builder relatedResources(Consumer<RelatedResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

