/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCardinalityRequest
extends IotRequest
implements ToCopyableBuilder<Builder, GetCardinalityRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(GetCardinalityRequest.getter(GetCardinalityRequest::indexName)).setter(GetCardinalityRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(GetCardinalityRequest.getter(GetCardinalityRequest::queryString)).setter(GetCardinalityRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationField").getter(GetCardinalityRequest.getter(GetCardinalityRequest::aggregationField)).setter(GetCardinalityRequest.setter(Builder::aggregationField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()}).build();
    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryVersion").getter(GetCardinalityRequest.getter(GetCardinalityRequest::queryVersion)).setter(GetCardinalityRequest.setter(Builder::queryVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, QUERY_STRING_FIELD, AGGREGATION_FIELD_FIELD, QUERY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCardinalityRequest.memberNameToFieldInitializer();
    private final String indexName;
    private final String queryString;
    private final String aggregationField;
    private final String queryVersion;

    private GetCardinalityRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.aggregationField = builder.aggregationField;
        this.queryVersion = builder.queryVersion;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String aggregationField() {
        return this.aggregationField;
    }

    public final String queryVersion() {
        return this.queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCardinalityRequest)) {
            return false;
        }
        GetCardinalityRequest other = (GetCardinalityRequest)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.aggregationField(), other.aggregationField()) && Objects.equals(this.queryVersion(), other.queryVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetCardinalityRequest").add("IndexName", (Object)this.indexName()).add("QueryString", (Object)this.queryString()).add("AggregationField", (Object)this.aggregationField()).add("QueryVersion", (Object)this.queryVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "aggregationField": {
                return Optional.ofNullable(clazz.cast(this.aggregationField()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("aggregationField", AGGREGATION_FIELD_FIELD);
        map.put("queryVersion", QUERY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCardinalityRequest, T> g) {
        return obj -> g.apply((GetCardinalityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String indexName;
        private String queryString;
        private String aggregationField;
        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCardinalityRequest model) {
            super(model);
            this.indexName(model.indexName);
            this.queryString(model.queryString);
            this.aggregationField(model.aggregationField);
            this.queryVersion(model.queryVersion);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getAggregationField() {
            return this.aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCardinalityRequest build() {
            return new GetCardinalityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCardinalityRequest> {
        public Builder indexName(String var1);

        public Builder queryString(String var1);

        public Builder aggregationField(String var1);

        public Builder queryVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

