/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditFrequency;
import software.amazon.awssdk.services.iot.model.DayOfWeek;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TargetAuditCheckNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScheduledAuditRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateScheduledAuditRequest> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frequency").getter(UpdateScheduledAuditRequest.getter(UpdateScheduledAuditRequest::frequencyAsString)).setter(UpdateScheduledAuditRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dayOfMonth").getter(UpdateScheduledAuditRequest.getter(UpdateScheduledAuditRequest::dayOfMonth)).setter(UpdateScheduledAuditRequest.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfMonth").build()}).build();
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dayOfWeek").getter(UpdateScheduledAuditRequest.getter(UpdateScheduledAuditRequest::dayOfWeekAsString)).setter(UpdateScheduledAuditRequest.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()}).build();
    private static final SdkField<List<String>> TARGET_CHECK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetCheckNames").getter(UpdateScheduledAuditRequest.getter(UpdateScheduledAuditRequest::targetCheckNames)).setter(UpdateScheduledAuditRequest.setter(Builder::targetCheckNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCheckNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledAuditName").getter(UpdateScheduledAuditRequest.getter(UpdateScheduledAuditRequest::scheduledAuditName)).setter(UpdateScheduledAuditRequest.setter(Builder::scheduledAuditName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("scheduledAuditName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, TARGET_CHECK_NAMES_FIELD, SCHEDULED_AUDIT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateScheduledAuditRequest.memberNameToFieldInitializer();
    private final String frequency;
    private final String dayOfMonth;
    private final String dayOfWeek;
    private final List<String> targetCheckNames;
    private final String scheduledAuditName;

    private UpdateScheduledAuditRequest(BuilderImpl builder) {
        super(builder);
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.targetCheckNames = builder.targetCheckNames;
        this.scheduledAuditName = builder.scheduledAuditName;
    }

    public final AuditFrequency frequency() {
        return AuditFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String dayOfMonth() {
        return this.dayOfMonth;
    }

    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public final String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public final boolean hasTargetCheckNames() {
        return this.targetCheckNames != null && !(this.targetCheckNames instanceof SdkAutoConstructList);
    }

    public final List<String> targetCheckNames() {
        return this.targetCheckNames;
    }

    public final String scheduledAuditName() {
        return this.scheduledAuditName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetCheckNames() ? this.targetCheckNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledAuditRequest)) {
            return false;
        }
        UpdateScheduledAuditRequest other = (UpdateScheduledAuditRequest)((Object)obj);
        return Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && this.hasTargetCheckNames() == other.hasTargetCheckNames() && Objects.equals(this.targetCheckNames(), other.targetCheckNames()) && Objects.equals(this.scheduledAuditName(), other.scheduledAuditName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScheduledAuditRequest").add("Frequency", (Object)this.frequencyAsString()).add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("TargetCheckNames", this.hasTargetCheckNames() ? this.targetCheckNames() : null).add("ScheduledAuditName", (Object)this.scheduledAuditName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "dayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "dayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
            case "targetCheckNames": {
                return Optional.ofNullable(clazz.cast(this.targetCheckNames()));
            }
            case "scheduledAuditName": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frequency", FREQUENCY_FIELD);
        map.put("dayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("dayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("targetCheckNames", TARGET_CHECK_NAMES_FIELD);
        map.put("scheduledAuditName", SCHEDULED_AUDIT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduledAuditRequest, T> g) {
        return obj -> g.apply((UpdateScheduledAuditRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String frequency;
        private String dayOfMonth;
        private String dayOfWeek;
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();
        private String scheduledAuditName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledAuditRequest model) {
            super(model);
            this.frequency(model.frequency);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
            this.targetCheckNames(model.targetCheckNames);
            this.scheduledAuditName(model.scheduledAuditName);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getDayOfMonth() {
            return this.dayOfMonth;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final Collection<String> getTargetCheckNames() {
            if (this.targetCheckNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetCheckNames;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String ... targetCheckNames) {
            this.targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduledAuditRequest build() {
            return new UpdateScheduledAuditRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScheduledAuditRequest> {
        public Builder frequency(String var1);

        public Builder frequency(AuditFrequency var1);

        public Builder dayOfMonth(String var1);

        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder targetCheckNames(Collection<String> var1);

        public Builder targetCheckNames(String ... var1);

        public Builder scheduledAuditName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

