/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMitigationActionResponse extends IotResponse implements
        ToCopyableBuilder<UpdateMitigationActionResponse.Builder, UpdateMitigationActionResponse> {
    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionArn").getter(getter(UpdateMitigationActionResponse::actionArn)).setter(setter(Builder::actionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionArn").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(UpdateMitigationActionResponse::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ARN_FIELD,
            ACTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionArn;

    private final String actionId;

    private UpdateMitigationActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionArn = builder.actionArn;
        this.actionId = builder.actionId;
    }

    /**
     * <p>
     * The ARN for the new mitigation action.
     * </p>
     * 
     * @return The ARN for the new mitigation action.
     */
    public final String actionArn() {
        return actionArn;
    }

    /**
     * <p>
     * A unique identifier for the mitigation action.
     * </p>
     * 
     * @return A unique identifier for the mitigation action.
     */
    public final String actionId() {
        return actionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMitigationActionResponse)) {
            return false;
        }
        UpdateMitigationActionResponse other = (UpdateMitigationActionResponse) obj;
        return Objects.equals(actionArn(), other.actionArn()) && Objects.equals(actionId(), other.actionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMitigationActionResponse").add("ActionArn", actionArn()).add("ActionId", actionId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionArn":
            return Optional.ofNullable(clazz.cast(actionArn()));
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionArn", ACTION_ARN_FIELD);
        map.put("actionId", ACTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMitigationActionResponse, T> g) {
        return obj -> g.apply((UpdateMitigationActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMitigationActionResponse> {
        /**
         * <p>
         * The ARN for the new mitigation action.
         * </p>
         * 
         * @param actionArn
         *        The ARN for the new mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionArn(String actionArn);

        /**
         * <p>
         * A unique identifier for the mitigation action.
         * </p>
         * 
         * @param actionId
         *        A unique identifier for the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String actionArn;

        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMitigationActionResponse model) {
            super(model);
            actionArn(model.actionArn);
            actionId(model.actionId);
        }

        public final String getActionArn() {
            return actionArn;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        @Override
        public UpdateMitigationActionResponse build() {
            return new UpdateMitigationActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
