/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure that contains <code>payloadVersion</code> and <code>targetArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningHook implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningHook.Builder, ProvisioningHook> {
    private static final SdkField<String> PAYLOAD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payloadVersion").getter(getter(ProvisioningHook::payloadVersion))
            .setter(setter(Builder::payloadVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadVersion").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetArn").getter(getter(ProvisioningHook::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_VERSION_FIELD,
            TARGET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String payloadVersion;

    private final String targetArn;

    private ProvisioningHook(BuilderImpl builder) {
        this.payloadVersion = builder.payloadVersion;
        this.targetArn = builder.targetArn;
    }

    /**
     * <p>
     * The payload that was sent to the target function.
     * </p>
     * <p>
     * <i>Note:</i> Only Lambda functions are currently supported.
     * </p>
     * 
     * @return The payload that was sent to the target function.</p>
     *         <p>
     *         <i>Note:</i> Only Lambda functions are currently supported.
     */
    public final String payloadVersion() {
        return payloadVersion;
    }

    /**
     * <p>
     * The ARN of the target function.
     * </p>
     * <p>
     * <i>Note:</i> Only Lambda functions are currently supported.
     * </p>
     * 
     * @return The ARN of the target function.</p>
     *         <p>
     *         <i>Note:</i> Only Lambda functions are currently supported.
     */
    public final String targetArn() {
        return targetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningHook)) {
            return false;
        }
        ProvisioningHook other = (ProvisioningHook) obj;
        return Objects.equals(payloadVersion(), other.payloadVersion()) && Objects.equals(targetArn(), other.targetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningHook").add("PayloadVersion", payloadVersion()).add("TargetArn", targetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payloadVersion":
            return Optional.ofNullable(clazz.cast(payloadVersion()));
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("payloadVersion", PAYLOAD_VERSION_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningHook, T> g) {
        return obj -> g.apply((ProvisioningHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningHook> {
        /**
         * <p>
         * The payload that was sent to the target function.
         * </p>
         * <p>
         * <i>Note:</i> Only Lambda functions are currently supported.
         * </p>
         * 
         * @param payloadVersion
         *        The payload that was sent to the target function.</p>
         *        <p>
         *        <i>Note:</i> Only Lambda functions are currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadVersion(String payloadVersion);

        /**
         * <p>
         * The ARN of the target function.
         * </p>
         * <p>
         * <i>Note:</i> Only Lambda functions are currently supported.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the target function.</p>
         *        <p>
         *        <i>Note:</i> Only Lambda functions are currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);
    }

    static final class BuilderImpl implements Builder {
        private String payloadVersion;

        private String targetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningHook model) {
            payloadVersion(model.payloadVersion);
            targetArn(model.targetArn);
        }

        public final String getPayloadVersion() {
            return payloadVersion;
        }

        public final void setPayloadVersion(String payloadVersion) {
            this.payloadVersion = payloadVersion;
        }

        @Override
        public final Builder payloadVersion(String payloadVersion) {
            this.payloadVersion = payloadVersion;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        @Override
        public ProvisioningHook build() {
            return new ProvisioningHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
