/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListViolationEventsResponse extends IotResponse implements
        ToCopyableBuilder<ListViolationEventsResponse.Builder, ListViolationEventsResponse> {
    private static final SdkField<List<ViolationEvent>> VIOLATION_EVENTS_FIELD = SdkField
            .<List<ViolationEvent>> builder(MarshallingType.LIST)
            .memberName("violationEvents")
            .getter(getter(ListViolationEventsResponse::violationEvents))
            .setter(setter(Builder::violationEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ViolationEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ViolationEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListViolationEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ViolationEvent> violationEvents;

    private final String nextToken;

    private ListViolationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.violationEvents = builder.violationEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolationEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolationEvents() {
        return violationEvents != null && !(violationEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security profile violation alerts issued for this account during the given time period, potentially filtered
     * by security profile, behavior violated, or thing (device) violating.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolationEvents} method.
     * </p>
     * 
     * @return The security profile violation alerts issued for this account during the given time period, potentially
     *         filtered by security profile, behavior violated, or thing (device) violating.
     */
    public final List<ViolationEvent> violationEvents() {
        return violationEvents;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasViolationEvents() ? violationEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListViolationEventsResponse)) {
            return false;
        }
        ListViolationEventsResponse other = (ListViolationEventsResponse) obj;
        return hasViolationEvents() == other.hasViolationEvents() && Objects.equals(violationEvents(), other.violationEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListViolationEventsResponse")
                .add("ViolationEvents", hasViolationEvents() ? violationEvents() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationEvents":
            return Optional.ofNullable(clazz.cast(violationEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("violationEvents", VIOLATION_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListViolationEventsResponse, T> g) {
        return obj -> g.apply((ListViolationEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListViolationEventsResponse> {
        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time period, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * 
         * @param violationEvents
         *        The security profile violation alerts issued for this account during the given time period,
         *        potentially filtered by security profile, behavior violated, or thing (device) violating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEvents(Collection<ViolationEvent> violationEvents);

        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time period, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * 
         * @param violationEvents
         *        The security profile violation alerts issued for this account during the given time period,
         *        potentially filtered by security profile, behavior violated, or thing (device) violating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationEvents(ViolationEvent... violationEvents);

        /**
         * <p>
         * The security profile violation alerts issued for this account during the given time period, potentially
         * filtered by security profile, behavior violated, or thing (device) violating.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.ViolationEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.ViolationEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.ViolationEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #violationEvents(List<ViolationEvent>)}.
         * 
         * @param violationEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.ViolationEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violationEvents(java.util.Collection<ViolationEvent>)
         */
        Builder violationEvents(Consumer<ViolationEvent.Builder>... violationEvents);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ViolationEvent> violationEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListViolationEventsResponse model) {
            super(model);
            violationEvents(model.violationEvents);
            nextToken(model.nextToken);
        }

        public final List<ViolationEvent.Builder> getViolationEvents() {
            List<ViolationEvent.Builder> result = ViolationEventsCopier.copyToBuilder(this.violationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolationEvents(Collection<ViolationEvent.BuilderImpl> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copyFromBuilder(violationEvents);
        }

        @Override
        public final Builder violationEvents(Collection<ViolationEvent> violationEvents) {
            this.violationEvents = ViolationEventsCopier.copy(violationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(ViolationEvent... violationEvents) {
            violationEvents(Arrays.asList(violationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationEvents(Consumer<ViolationEvent.Builder>... violationEvents) {
            violationEvents(Stream.of(violationEvents).map(c -> ViolationEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListViolationEventsResponse build() {
            return new ListViolationEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
