/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityProfilesForTargetResponse extends IotResponse implements
        ToCopyableBuilder<ListSecurityProfilesForTargetResponse.Builder, ListSecurityProfilesForTargetResponse> {
    private static final SdkField<List<SecurityProfileTargetMapping>> SECURITY_PROFILE_TARGET_MAPPINGS_FIELD = SdkField
            .<List<SecurityProfileTargetMapping>> builder(MarshallingType.LIST)
            .memberName("securityProfileTargetMappings")
            .getter(getter(ListSecurityProfilesForTargetResponse::securityProfileTargetMappings))
            .setter(setter(Builder::securityProfileTargetMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileTargetMappings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityProfileTargetMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityProfileTargetMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSecurityProfilesForTargetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SECURITY_PROFILE_TARGET_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SecurityProfileTargetMapping> securityProfileTargetMappings;

    private final String nextToken;

    private ListSecurityProfilesForTargetResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileTargetMappings = builder.securityProfileTargetMappings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityProfileTargetMappings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityProfileTargetMappings() {
        return securityProfileTargetMappings != null && !(securityProfileTargetMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security profiles and their associated targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityProfileTargetMappings} method.
     * </p>
     * 
     * @return A list of security profiles and their associated targets.
     */
    public final List<SecurityProfileTargetMapping> securityProfileTargetMappings() {
        return securityProfileTargetMappings;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityProfileTargetMappings() ? securityProfileTargetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilesForTargetResponse)) {
            return false;
        }
        ListSecurityProfilesForTargetResponse other = (ListSecurityProfilesForTargetResponse) obj;
        return hasSecurityProfileTargetMappings() == other.hasSecurityProfileTargetMappings()
                && Objects.equals(securityProfileTargetMappings(), other.securityProfileTargetMappings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListSecurityProfilesForTargetResponse")
                .add("SecurityProfileTargetMappings", hasSecurityProfileTargetMappings() ? securityProfileTargetMappings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileTargetMappings":
            return Optional.ofNullable(clazz.cast(securityProfileTargetMappings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("securityProfileTargetMappings", SECURITY_PROFILE_TARGET_MAPPINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilesForTargetResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilesForTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSecurityProfilesForTargetResponse> {
        /**
         * <p>
         * A list of security profiles and their associated targets.
         * </p>
         * 
         * @param securityProfileTargetMappings
         *        A list of security profiles and their associated targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> securityProfileTargetMappings);

        /**
         * <p>
         * A list of security profiles and their associated targets.
         * </p>
         * 
         * @param securityProfileTargetMappings
         *        A list of security profiles and their associated targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargetMappings(SecurityProfileTargetMapping... securityProfileTargetMappings);

        /**
         * <p>
         * A list of security profiles and their associated targets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #securityProfileTargetMappings(List<SecurityProfileTargetMapping>)}.
         * 
         * @param securityProfileTargetMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityProfileTargetMappings(java.util.Collection<SecurityProfileTargetMapping>)
         */
        Builder securityProfileTargetMappings(Consumer<SecurityProfileTargetMapping.Builder>... securityProfileTargetMappings);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<SecurityProfileTargetMapping> securityProfileTargetMappings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilesForTargetResponse model) {
            super(model);
            securityProfileTargetMappings(model.securityProfileTargetMappings);
            nextToken(model.nextToken);
        }

        public final List<SecurityProfileTargetMapping.Builder> getSecurityProfileTargetMappings() {
            List<SecurityProfileTargetMapping.Builder> result = SecurityProfileTargetMappingsCopier
                    .copyToBuilder(this.securityProfileTargetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityProfileTargetMappings(
                Collection<SecurityProfileTargetMapping.BuilderImpl> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier
                    .copyFromBuilder(securityProfileTargetMappings);
        }

        @Override
        public final Builder securityProfileTargetMappings(Collection<SecurityProfileTargetMapping> securityProfileTargetMappings) {
            this.securityProfileTargetMappings = SecurityProfileTargetMappingsCopier.copy(securityProfileTargetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(SecurityProfileTargetMapping... securityProfileTargetMappings) {
            securityProfileTargetMappings(Arrays.asList(securityProfileTargetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileTargetMappings(
                Consumer<SecurityProfileTargetMapping.Builder>... securityProfileTargetMappings) {
            securityProfileTargetMappings(Stream.of(securityProfileTargetMappings)
                    .map(c -> SecurityProfileTargetMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityProfilesForTargetResponse build() {
            return new ListSecurityProfilesForTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
