/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DeprecateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprecateThingTypeRequest extends IotRequest implements
        ToCopyableBuilder<DeprecateThingTypeRequest.Builder, DeprecateThingTypeRequest> {
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(DeprecateThingTypeRequest::thingTypeName))
            .setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingTypeName").build()).build();

    private static final SdkField<Boolean> UNDO_DEPRECATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("undoDeprecate").getter(getter(DeprecateThingTypeRequest::undoDeprecate))
            .setter(setter(Builder::undoDeprecate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("undoDeprecate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_NAME_FIELD,
            UNDO_DEPRECATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingTypeName;

    private final Boolean undoDeprecate;

    private DeprecateThingTypeRequest(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.undoDeprecate = builder.undoDeprecate;
    }

    /**
     * <p>
     * The name of the thing type to deprecate.
     * </p>
     * 
     * @return The name of the thing type to deprecate.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and
     * you can associate it with things.
     * </p>
     * 
     * @return Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated
     *         anymore and you can associate it with things.
     */
    public final Boolean undoDeprecate() {
        return undoDeprecate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(undoDeprecate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateThingTypeRequest)) {
            return false;
        }
        DeprecateThingTypeRequest other = (DeprecateThingTypeRequest) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName()) && Objects.equals(undoDeprecate(), other.undoDeprecate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprecateThingTypeRequest").add("ThingTypeName", thingTypeName())
                .add("UndoDeprecate", undoDeprecate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "undoDeprecate":
            return Optional.ofNullable(clazz.cast(undoDeprecate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingTypeName", THING_TYPE_NAME_FIELD);
        map.put("undoDeprecate", UNDO_DEPRECATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprecateThingTypeRequest, T> g) {
        return obj -> g.apply((DeprecateThingTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeprecateThingTypeRequest> {
        /**
         * <p>
         * The name of the thing type to deprecate.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type to deprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore
         * and you can associate it with things.
         * </p>
         * 
         * @param undoDeprecate
         *        Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated
         *        anymore and you can associate it with things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undoDeprecate(Boolean undoDeprecate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingTypeName;

        private Boolean undoDeprecate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateThingTypeRequest model) {
            super(model);
            thingTypeName(model.thingTypeName);
            undoDeprecate(model.undoDeprecate);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final Boolean getUndoDeprecate() {
            return undoDeprecate;
        }

        public final void setUndoDeprecate(Boolean undoDeprecate) {
            this.undoDeprecate = undoDeprecate;
        }

        @Override
        public final Builder undoDeprecate(Boolean undoDeprecate) {
            this.undoDeprecate = undoDeprecate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeprecateThingTypeRequest build() {
            return new DeprecateThingTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
