/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The certificate provider summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateProviderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateProviderSummary.Builder, CertificateProviderSummary> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderName").getter(getter(CertificateProviderSummary::certificateProviderName))
            .setter(setter(Builder::certificateProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderName").build())
            .build();

    private static final SdkField<String> CERTIFICATE_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderArn").getter(getter(CertificateProviderSummary::certificateProviderArn))
            .setter(setter(Builder::certificateProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateProviderArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_PROVIDER_NAME_FIELD, CERTIFICATE_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateProviderName;

    private final String certificateProviderArn;

    private CertificateProviderSummary(BuilderImpl builder) {
        this.certificateProviderName = builder.certificateProviderName;
        this.certificateProviderArn = builder.certificateProviderArn;
    }

    /**
     * <p>
     * The name of the certificate provider.
     * </p>
     * 
     * @return The name of the certificate provider.
     */
    public final String certificateProviderName() {
        return certificateProviderName;
    }

    /**
     * <p>
     * The ARN of the certificate provider.
     * </p>
     * 
     * @return The ARN of the certificate provider.
     */
    public final String certificateProviderArn() {
        return certificateProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateProviderSummary)) {
            return false;
        }
        CertificateProviderSummary other = (CertificateProviderSummary) obj;
        return Objects.equals(certificateProviderName(), other.certificateProviderName())
                && Objects.equals(certificateProviderArn(), other.certificateProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateProviderSummary").add("CertificateProviderName", certificateProviderName())
                .add("CertificateProviderArn", certificateProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateProviderName":
            return Optional.ofNullable(clazz.cast(certificateProviderName()));
        case "certificateProviderArn":
            return Optional.ofNullable(clazz.cast(certificateProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateProviderName", CERTIFICATE_PROVIDER_NAME_FIELD);
        map.put("certificateProviderArn", CERTIFICATE_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateProviderSummary, T> g) {
        return obj -> g.apply((CertificateProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateProviderSummary> {
        /**
         * <p>
         * The name of the certificate provider.
         * </p>
         * 
         * @param certificateProviderName
         *        The name of the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateProviderName(String certificateProviderName);

        /**
         * <p>
         * The ARN of the certificate provider.
         * </p>
         * 
         * @param certificateProviderArn
         *        The ARN of the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateProviderArn(String certificateProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String certificateProviderName;

        private String certificateProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateProviderSummary model) {
            certificateProviderName(model.certificateProviderName);
            certificateProviderArn(model.certificateProviderArn);
        }

        public final String getCertificateProviderName() {
            return certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getCertificateProviderArn() {
            return certificateProviderArn;
        }

        public final void setCertificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
        }

        @Override
        public final Builder certificateProviderArn(String certificateProviderArn) {
            this.certificateProviderArn = certificateProviderArn;
            return this;
        }

        @Override
        public CertificateProviderSummary build() {
            return new CertificateProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
