/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ThingPrincipalObject;
import software.amazon.awssdk.services.iot.model.ThingPrincipalObjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingPrincipalsV2Response
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingPrincipalsV2Response> {
    private static final SdkField<List<ThingPrincipalObject>> THING_PRINCIPAL_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("thingPrincipalObjects").getter(ListThingPrincipalsV2Response.getter(ListThingPrincipalsV2Response::thingPrincipalObjects)).setter(ListThingPrincipalsV2Response.setter(Builder::thingPrincipalObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingPrincipalObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThingPrincipalObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListThingPrincipalsV2Response.getter(ListThingPrincipalsV2Response::nextToken)).setter(ListThingPrincipalsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_PRINCIPAL_OBJECTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListThingPrincipalsV2Response.memberNameToFieldInitializer();
    private final List<ThingPrincipalObject> thingPrincipalObjects;
    private final String nextToken;

    private ListThingPrincipalsV2Response(BuilderImpl builder) {
        super(builder);
        this.thingPrincipalObjects = builder.thingPrincipalObjects;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThingPrincipalObjects() {
        return this.thingPrincipalObjects != null && !(this.thingPrincipalObjects instanceof SdkAutoConstructList);
    }

    public final List<ThingPrincipalObject> thingPrincipalObjects() {
        return this.thingPrincipalObjects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThingPrincipalObjects() ? this.thingPrincipalObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsV2Response)) {
            return false;
        }
        ListThingPrincipalsV2Response other = (ListThingPrincipalsV2Response)((Object)obj);
        return this.hasThingPrincipalObjects() == other.hasThingPrincipalObjects() && Objects.equals(this.thingPrincipalObjects(), other.thingPrincipalObjects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThingPrincipalsV2Response").add("ThingPrincipalObjects", this.hasThingPrincipalObjects() ? this.thingPrincipalObjects() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingPrincipalObjects": {
                return Optional.ofNullable(clazz.cast(this.thingPrincipalObjects()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thingPrincipalObjects", THING_PRINCIPAL_OBJECTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingPrincipalsV2Response, T> g) {
        return obj -> g.apply((ListThingPrincipalsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<ThingPrincipalObject> thingPrincipalObjects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsV2Response model) {
            super(model);
            this.thingPrincipalObjects(model.thingPrincipalObjects);
            this.nextToken(model.nextToken);
        }

        public final List<ThingPrincipalObject.Builder> getThingPrincipalObjects() {
            List<ThingPrincipalObject.Builder> result = ThingPrincipalObjectsCopier.copyToBuilder(this.thingPrincipalObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingPrincipalObjects(Collection<ThingPrincipalObject.BuilderImpl> thingPrincipalObjects) {
            this.thingPrincipalObjects = ThingPrincipalObjectsCopier.copyFromBuilder(thingPrincipalObjects);
        }

        @Override
        public final Builder thingPrincipalObjects(Collection<ThingPrincipalObject> thingPrincipalObjects) {
            this.thingPrincipalObjects = ThingPrincipalObjectsCopier.copy(thingPrincipalObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingPrincipalObjects(ThingPrincipalObject ... thingPrincipalObjects) {
            this.thingPrincipalObjects(Arrays.asList(thingPrincipalObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingPrincipalObjects(Consumer<ThingPrincipalObject.Builder> ... thingPrincipalObjects) {
            this.thingPrincipalObjects(Stream.of(thingPrincipalObjects).map(c -> (ThingPrincipalObject)((ThingPrincipalObject.Builder)ThingPrincipalObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingPrincipalsV2Response build() {
            return new ListThingPrincipalsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingPrincipalsV2Response> {
        public Builder thingPrincipalObjects(Collection<ThingPrincipalObject> var1);

        public Builder thingPrincipalObjects(ThingPrincipalObject ... var1);

        public Builder thingPrincipalObjects(Consumer<ThingPrincipalObject.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

