/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the validation results for a specific software bill of materials (SBOM) attached to a software package
 * version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SbomValidationResultSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SbomValidationResultSummary.Builder, SbomValidationResultSummary> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(SbomValidationResultSummary::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> VALIDATION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationResult").getter(getter(SbomValidationResultSummary::validationResultAsString))
            .setter(setter(Builder::validationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationResult").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(SbomValidationResultSummary::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(SbomValidationResultSummary::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD,
            VALIDATION_RESULT_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileName;

    private final String validationResult;

    private final String errorCode;

    private final String errorMessage;

    private SbomValidationResultSummary(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.validationResult = builder.validationResult;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the SBOM file.
     * </p>
     * 
     * @return The name of the SBOM file.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The end result of the SBOM validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationResult}
     * will return {@link SbomValidationResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationResultAsString}.
     * </p>
     * 
     * @return The end result of the SBOM validation.
     * @see SbomValidationResult
     */
    public final SbomValidationResult validationResult() {
        return SbomValidationResult.fromValue(validationResult);
    }

    /**
     * <p>
     * The end result of the SBOM validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationResult}
     * will return {@link SbomValidationResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationResultAsString}.
     * </p>
     * 
     * @return The end result of the SBOM validation.
     * @see SbomValidationResult
     */
    public final String validationResultAsString() {
        return validationResult;
    }

    /**
     * <p>
     * The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link SbomValidationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
     * @see SbomValidationErrorCode
     */
    public final SbomValidationErrorCode errorCode() {
        return SbomValidationErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link SbomValidationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
     * @see SbomValidationErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The <code>errorMessage</code> representing the validation failure error if the SBOM validation failed.
     * </p>
     * 
     * @return The <code>errorMessage</code> representing the validation failure error if the SBOM validation failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(validationResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SbomValidationResultSummary)) {
            return false;
        }
        SbomValidationResultSummary other = (SbomValidationResultSummary) obj;
        return Objects.equals(fileName(), other.fileName())
                && Objects.equals(validationResultAsString(), other.validationResultAsString())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SbomValidationResultSummary").add("FileName", fileName())
                .add("ValidationResult", validationResultAsString()).add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "validationResult":
            return Optional.ofNullable(clazz.cast(validationResultAsString()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileName", FILE_NAME_FIELD);
        map.put("validationResult", VALIDATION_RESULT_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SbomValidationResultSummary, T> g) {
        return obj -> g.apply((SbomValidationResultSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SbomValidationResultSummary> {
        /**
         * <p>
         * The name of the SBOM file.
         * </p>
         * 
         * @param fileName
         *        The name of the SBOM file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The end result of the SBOM validation.
         * </p>
         * 
         * @param validationResult
         *        The end result of the SBOM validation.
         * @see SbomValidationResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationResult
         */
        Builder validationResult(String validationResult);

        /**
         * <p>
         * The end result of the SBOM validation.
         * </p>
         * 
         * @param validationResult
         *        The end result of the SBOM validation.
         * @see SbomValidationResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationResult
         */
        Builder validationResult(SbomValidationResult validationResult);

        /**
         * <p>
         * The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
         * </p>
         * 
         * @param errorCode
         *        The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
         * @see SbomValidationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
         * </p>
         * 
         * @param errorCode
         *        The <code>errorCode</code> representing the validation failure error if the SBOM validation failed.
         * @see SbomValidationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationErrorCode
         */
        Builder errorCode(SbomValidationErrorCode errorCode);

        /**
         * <p>
         * The <code>errorMessage</code> representing the validation failure error if the SBOM validation failed.
         * </p>
         * 
         * @param errorMessage
         *        The <code>errorMessage</code> representing the validation failure error if the SBOM validation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private String validationResult;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SbomValidationResultSummary model) {
            fileName(model.fileName);
            validationResult(model.validationResult);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getValidationResult() {
            return validationResult;
        }

        public final void setValidationResult(String validationResult) {
            this.validationResult = validationResult;
        }

        @Override
        public final Builder validationResult(String validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        @Override
        public final Builder validationResult(SbomValidationResult validationResult) {
            this.validationResult(validationResult == null ? null : validationResult.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(SbomValidationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public SbomValidationResultSummary build() {
            return new SbomValidationResultSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
