/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPrincipalThingsV2Response extends IotResponse implements
        ToCopyableBuilder<ListPrincipalThingsV2Response.Builder, ListPrincipalThingsV2Response> {
    private static final SdkField<List<PrincipalThingObject>> PRINCIPAL_THING_OBJECTS_FIELD = SdkField
            .<List<PrincipalThingObject>> builder(MarshallingType.LIST)
            .memberName("principalThingObjects")
            .getter(getter(ListPrincipalThingsV2Response::principalThingObjects))
            .setter(setter(Builder::principalThingObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalThingObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalThingObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalThingObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPrincipalThingsV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_THING_OBJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PrincipalThingObject> principalThingObjects;

    private final String nextToken;

    private ListPrincipalThingsV2Response(BuilderImpl builder) {
        super(builder);
        this.principalThingObjects = builder.principalThingObjects;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrincipalThingObjects property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrincipalThingObjects() {
        return principalThingObjects != null && !(principalThingObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has with
     * the thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipalThingObjects} method.
     * </p>
     * 
     * @return A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
     *         with the thing.
     */
    public final List<PrincipalThingObject> principalThingObjects() {
        return principalThingObjects;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipalThingObjects() ? principalThingObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalThingsV2Response)) {
            return false;
        }
        ListPrincipalThingsV2Response other = (ListPrincipalThingsV2Response) obj;
        return hasPrincipalThingObjects() == other.hasPrincipalThingObjects()
                && Objects.equals(principalThingObjects(), other.principalThingObjects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPrincipalThingsV2Response")
                .add("PrincipalThingObjects", hasPrincipalThingObjects() ? principalThingObjects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principalThingObjects":
            return Optional.ofNullable(clazz.cast(principalThingObjects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("principalThingObjects", PRINCIPAL_THING_OBJECTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalThingsV2Response, T> g) {
        return obj -> g.apply((ListPrincipalThingsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPrincipalThingsV2Response> {
        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * 
         * @param principalThingObjects
         *        A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it
         *        has with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalThingObjects(Collection<PrincipalThingObject> principalThingObjects);

        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * 
         * @param principalThingObjects
         *        A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it
         *        has with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalThingObjects(PrincipalThingObject... principalThingObjects);

        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.PrincipalThingObject.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iot.model.PrincipalThingObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.PrincipalThingObject.Builder#build()} is called immediately
         * and its result is passed to {@link #principalThingObjects(List<PrincipalThingObject>)}.
         * 
         * @param principalThingObjects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.PrincipalThingObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principalThingObjects(java.util.Collection<PrincipalThingObject>)
         */
        Builder principalThingObjects(Consumer<PrincipalThingObject.Builder>... principalThingObjects);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<PrincipalThingObject> principalThingObjects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalThingsV2Response model) {
            super(model);
            principalThingObjects(model.principalThingObjects);
            nextToken(model.nextToken);
        }

        public final List<PrincipalThingObject.Builder> getPrincipalThingObjects() {
            List<PrincipalThingObject.Builder> result = PrincipalThingObjectsCopier.copyToBuilder(this.principalThingObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipalThingObjects(Collection<PrincipalThingObject.BuilderImpl> principalThingObjects) {
            this.principalThingObjects = PrincipalThingObjectsCopier.copyFromBuilder(principalThingObjects);
        }

        @Override
        public final Builder principalThingObjects(Collection<PrincipalThingObject> principalThingObjects) {
            this.principalThingObjects = PrincipalThingObjectsCopier.copy(principalThingObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalThingObjects(PrincipalThingObject... principalThingObjects) {
            principalThingObjects(Arrays.asList(principalThingObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalThingObjects(Consumer<PrincipalThingObject.Builder>... principalThingObjects) {
            principalThingObjects(Stream.of(principalThingObjects)
                    .map(c -> PrincipalThingObject.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrincipalThingsV2Response build() {
            return new ListPrincipalThingsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
