/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDetectMitigationActionsExecutionsRequest extends IotRequest implements
        ToCopyableBuilder<ListDetectMitigationActionsExecutionsRequest.Builder, ListDetectMitigationActionsExecutionsRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(ListDetectMitigationActionsExecutionsRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskId").build()).build();

    private static final SdkField<String> VIOLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("violationId").getter(getter(ListDetectMitigationActionsExecutionsRequest::violationId))
            .setter(setter(Builder::violationId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("violationId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ListDetectMitigationActionsExecutionsRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListDetectMitigationActionsExecutionsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListDetectMitigationActionsExecutionsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDetectMitigationActionsExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDetectMitigationActionsExecutionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            VIOLATION_ID_FIELD, THING_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskId;

    private final String violationId;

    private final String thingName;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private ListDetectMitigationActionsExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.violationId = builder.violationId;
        this.thingName = builder.thingName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the task.
     * </p>
     * 
     * @return The unique identifier of the task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The unique identifier of the violation.
     * </p>
     * 
     * @return The unique identifier of the violation.
     */
    public final String violationId() {
        return violationId;
    }

    /**
     * <p>
     * The name of the thing whose mitigation actions are listed.
     * </p>
     * 
     * @return The name of the thing whose mitigation actions are listed.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * A filter to limit results to those found after the specified time. You must specify either the startTime and
     * endTime or the taskId, but not both.
     * </p>
     * 
     * @return A filter to limit results to those found after the specified time. You must specify either the startTime
     *         and endTime or the taskId, but not both.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period for which ML Detect mitigation actions executions are returned.
     * </p>
     * 
     * @return The end of the time period for which ML Detect mitigation actions executions are returned.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(violationId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectMitigationActionsExecutionsRequest)) {
            return false;
        }
        ListDetectMitigationActionsExecutionsRequest other = (ListDetectMitigationActionsExecutionsRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(violationId(), other.violationId())
                && Objects.equals(thingName(), other.thingName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDetectMitigationActionsExecutionsRequest").add("TaskId", taskId())
                .add("ViolationId", violationId()).add("ThingName", thingName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "violationId":
            return Optional.ofNullable(clazz.cast(violationId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("violationId", VIOLATION_ID_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDetectMitigationActionsExecutionsRequest, T> g) {
        return obj -> g.apply((ListDetectMitigationActionsExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDetectMitigationActionsExecutionsRequest> {
        /**
         * <p>
         * The unique identifier of the task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The unique identifier of the violation.
         * </p>
         * 
         * @param violationId
         *        The unique identifier of the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationId(String violationId);

        /**
         * <p>
         * The name of the thing whose mitigation actions are listed.
         * </p>
         * 
         * @param thingName
         *        The name of the thing whose mitigation actions are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A filter to limit results to those found after the specified time. You must specify either the startTime and
         * endTime or the taskId, but not both.
         * </p>
         * 
         * @param startTime
         *        A filter to limit results to those found after the specified time. You must specify either the
         *        startTime and endTime or the taskId, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period for which ML Detect mitigation actions executions are returned.
         * </p>
         * 
         * @param endTime
         *        The end of the time period for which ML Detect mitigation actions executions are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String taskId;

        private String violationId;

        private String thingName;

        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectMitigationActionsExecutionsRequest model) {
            super(model);
            taskId(model.taskId);
            violationId(model.violationId);
            thingName(model.thingName);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getViolationId() {
            return violationId;
        }

        public final void setViolationId(String violationId) {
            this.violationId = violationId;
        }

        @Override
        public final Builder violationId(String violationId) {
            this.violationId = violationId;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDetectMitigationActionsExecutionsRequest build() {
            return new ListDetectMitigationActionsExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
