/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyPair implements SdkPojo, Serializable, ToCopyableBuilder<KeyPair.Builder, KeyPair> {
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(KeyPair::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKey").getter(getter(KeyPair::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_FIELD,
            PRIVATE_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String publicKey;

    private final String privateKey;

    private KeyPair(BuilderImpl builder) {
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
    }

    /**
     * <p>
     * The public key.
     * </p>
     * 
     * @return The public key.
     */
    public final String publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * The private key.
     * </p>
     * 
     * @return The private key.
     */
    public final String privateKey() {
        return privateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair) obj;
        return Objects.equals(publicKey(), other.publicKey()) && Objects.equals(privateKey(), other.privateKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyPair").add("PublicKey", publicKey())
                .add("PrivateKey", privateKey() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        map.put("PrivateKey", PRIVATE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyPair, T> g) {
        return obj -> g.apply((KeyPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyPair> {
        /**
         * <p>
         * The public key.
         * </p>
         * 
         * @param publicKey
         *        The public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * The private key.
         * </p>
         * 
         * @param privateKey
         *        The private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);
    }

    static final class BuilderImpl implements Builder {
        private String publicKey;

        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            publicKey(model.publicKey);
            privateKey(model.privateKey);
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public KeyPair build() {
            return new KeyPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
