/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and ARN of a fleet metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetMetricNameAndArn implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetMetricNameAndArn.Builder, FleetMetricNameAndArn> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(FleetMetricNameAndArn::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricArn").getter(getter(FleetMetricNameAndArn::metricArn)).setter(setter(Builder::metricArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String metricArn;

    private FleetMetricNameAndArn(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricArn = builder.metricArn;
    }

    /**
     * <p>
     * The fleet metric name.
     * </p>
     * 
     * @return The fleet metric name.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The fleet metric ARN.
     * </p>
     * 
     * @return The fleet metric ARN.
     */
    public final String metricArn() {
        return metricArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetMetricNameAndArn)) {
            return false;
        }
        FleetMetricNameAndArn other = (FleetMetricNameAndArn) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(metricArn(), other.metricArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetMetricNameAndArn").add("MetricName", metricName()).add("MetricArn", metricArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricArn":
            return Optional.ofNullable(clazz.cast(metricArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("metricArn", METRIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetMetricNameAndArn, T> g) {
        return obj -> g.apply((FleetMetricNameAndArn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetMetricNameAndArn> {
        /**
         * <p>
         * The fleet metric name.
         * </p>
         * 
         * @param metricName
         *        The fleet metric name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The fleet metric ARN.
         * </p>
         * 
         * @param metricArn
         *        The fleet metric ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricArn(String metricArn);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String metricArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetMetricNameAndArn model) {
            metricName(model.metricName);
            metricArn(model.metricArn);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getMetricArn() {
            return metricArn;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        @Override
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        @Override
        public FleetMetricNameAndArn build() {
            return new FleetMetricNameAndArn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
