/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target of a mitigation action task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectMitigationActionsTaskTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectMitigationActionsTaskTarget.Builder, DetectMitigationActionsTaskTarget> {
    private static final SdkField<List<String>> VIOLATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("violationIds")
            .getter(getter(DetectMitigationActionsTaskTarget::violationIds))
            .setter(setter(Builder::violationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("violationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(DetectMitigationActionsTaskTarget::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build())
            .build();

    private static final SdkField<String> BEHAVIOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("behaviorName").getter(getter(DetectMitigationActionsTaskTarget::behaviorName))
            .setter(setter(Builder::behaviorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_IDS_FIELD,
            SECURITY_PROFILE_NAME_FIELD, BEHAVIOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> violationIds;

    private final String securityProfileName;

    private final String behaviorName;

    private DetectMitigationActionsTaskTarget(BuilderImpl builder) {
        this.violationIds = builder.violationIds;
        this.securityProfileName = builder.securityProfileName;
        this.behaviorName = builder.behaviorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolationIds() {
        return violationIds != null && !(violationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the violations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolationIds} method.
     * </p>
     * 
     * @return The unique identifiers of the violations.
     */
    public final List<String> violationIds() {
        return violationIds;
    }

    /**
     * <p>
     * The name of the security profile.
     * </p>
     * 
     * @return The name of the security profile.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The name of the behavior.
     * </p>
     * 
     * @return The name of the behavior.
     */
    public final String behaviorName() {
        return behaviorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasViolationIds() ? violationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectMitigationActionsTaskTarget)) {
            return false;
        }
        DetectMitigationActionsTaskTarget other = (DetectMitigationActionsTaskTarget) obj;
        return hasViolationIds() == other.hasViolationIds() && Objects.equals(violationIds(), other.violationIds())
                && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(behaviorName(), other.behaviorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectMitigationActionsTaskTarget")
                .add("ViolationIds", hasViolationIds() ? violationIds() : null).add("SecurityProfileName", securityProfileName())
                .add("BehaviorName", behaviorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "violationIds":
            return Optional.ofNullable(clazz.cast(violationIds()));
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "behaviorName":
            return Optional.ofNullable(clazz.cast(behaviorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("violationIds", VIOLATION_IDS_FIELD);
        map.put("securityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("behaviorName", BEHAVIOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectMitigationActionsTaskTarget, T> g) {
        return obj -> g.apply((DetectMitigationActionsTaskTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectMitigationActionsTaskTarget> {
        /**
         * <p>
         * The unique identifiers of the violations.
         * </p>
         * 
         * @param violationIds
         *        The unique identifiers of the violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationIds(Collection<String> violationIds);

        /**
         * <p>
         * The unique identifiers of the violations.
         * </p>
         * 
         * @param violationIds
         *        The unique identifiers of the violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationIds(String... violationIds);

        /**
         * <p>
         * The name of the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The name of the behavior.
         * </p>
         * 
         * @param behaviorName
         *        The name of the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder behaviorName(String behaviorName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> violationIds = DefaultSdkAutoConstructList.getInstance();

        private String securityProfileName;

        private String behaviorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectMitigationActionsTaskTarget model) {
            violationIds(model.violationIds);
            securityProfileName(model.securityProfileName);
            behaviorName(model.behaviorName);
        }

        public final Collection<String> getViolationIds() {
            if (violationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return violationIds;
        }

        public final void setViolationIds(Collection<String> violationIds) {
            this.violationIds = TargetViolationIdsForDetectMitigationActionsCopier.copy(violationIds);
        }

        @Override
        public final Builder violationIds(Collection<String> violationIds) {
            this.violationIds = TargetViolationIdsForDetectMitigationActionsCopier.copy(violationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violationIds(String... violationIds) {
            violationIds(Arrays.asList(violationIds));
            return this;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getBehaviorName() {
            return behaviorName;
        }

        public final void setBehaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
        }

        @Override
        public final Builder behaviorName(String behaviorName) {
            this.behaviorName = behaviorName;
            return this;
        }

        @Override
        public DetectMitigationActionsTaskTarget build() {
            return new DetectMitigationActionsTaskTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
