/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageVersionResponse extends IotResponse implements
        ToCopyableBuilder<CreatePackageVersionResponse.Builder, CreatePackageVersionResponse> {
    private static final SdkField<String> PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageVersionArn").getter(getter(CreatePackageVersionResponse::packageVersionArn))
            .setter(setter(Builder::packageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersionArn").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(CreatePackageVersionResponse::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(CreatePackageVersionResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePackageVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(CreatePackageVersionResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreatePackageVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorReason").getter(getter(CreatePackageVersionResponse::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_ARN_FIELD,
            PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTES_FIELD, STATUS_FIELD, ERROR_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageVersionArn;

    private final String packageName;

    private final String versionName;

    private final String description;

    private final Map<String, String> attributes;

    private final String status;

    private final String errorReason;

    private CreatePackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersionArn = builder.packageVersionArn;
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.attributes = builder.attributes;
        this.status = builder.status;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the package.
     */
    public final String packageVersionArn() {
        return packageVersionArn;
    }

    /**
     * <p>
     * The name of the associated software package.
     * </p>
     * 
     * @return The name of the associated software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The name of the new package version.
     * </p>
     * 
     * @return The name of the new package version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The package version description.
     * </p>
     * 
     * @return The package version description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that were added to the package version that can be used to define a package version’s configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Metadata that were added to the package version that can be used to define a package version’s
     *         configuration.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The status of the package version. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     * >Package version lifecycle</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the package version. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     *         >Package version lifecycle</a>.
     * @see PackageVersionStatus
     */
    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the package version. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     * >Package version lifecycle</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the package version. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     *         >Package version lifecycle</a>.
     * @see PackageVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error reason for a package version failure during creation or update.
     * </p>
     * 
     * @return Error reason for a package version failure during creation or update.
     */
    public final String errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageVersionResponse)) {
            return false;
        }
        CreatePackageVersionResponse other = (CreatePackageVersionResponse) obj;
        return Objects.equals(packageVersionArn(), other.packageVersionArn())
                && Objects.equals(packageName(), other.packageName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(description(), other.description()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageVersionResponse").add("PackageVersionArn", packageVersionArn())
                .add("PackageName", packageName()).add("VersionName", versionName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Attributes", attributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageVersionArn":
            return Optional.ofNullable(clazz.cast(packageVersionArn()));
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageVersionArn", PACKAGE_VERSION_ARN_FIELD);
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("errorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageVersionResponse, T> g) {
        return obj -> g.apply((CreatePackageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageVersionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the package.
         * </p>
         * 
         * @param packageVersionArn
         *        The Amazon Resource Name (ARN) for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionArn(String packageVersionArn);

        /**
         * <p>
         * The name of the associated software package.
         * </p>
         * 
         * @param packageName
         *        The name of the associated software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The name of the new package version.
         * </p>
         * 
         * @param versionName
         *        The name of the new package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The package version description.
         * </p>
         * 
         * @param description
         *        The package version description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Metadata that were added to the package version that can be used to define a package version’s configuration.
         * </p>
         * 
         * @param attributes
         *        Metadata that were added to the package version that can be used to define a package version’s
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The status of the package version. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * 
         * @param status
         *        The status of the package version. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the package version. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * 
         * @param status
         *        The status of the package version. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(PackageVersionStatus status);

        /**
         * <p>
         * Error reason for a package version failure during creation or update.
         * </p>
         * 
         * @param errorReason
         *        Error reason for a package version failure during creation or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String packageVersionArn;

        private String packageName;

        private String versionName;

        private String description;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageVersionResponse model) {
            super(model);
            packageVersionArn(model.packageVersionArn);
            packageName(model.packageName);
            versionName(model.versionName);
            description(model.description);
            attributes(model.attributes);
            status(model.status);
            errorReason(model.errorReason);
        }

        public final String getPackageVersionArn() {
            return packageVersionArn;
        }

        public final void setPackageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
        }

        @Override
        public final Builder packageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public CreatePackageVersionResponse build() {
            return new CreatePackageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
