/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorizer result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthResult implements SdkPojo, Serializable, ToCopyableBuilder<AuthResult.Builder, AuthResult> {
    private static final SdkField<AuthInfo> AUTH_INFO_FIELD = SdkField.<AuthInfo> builder(MarshallingType.SDK_POJO)
            .memberName("authInfo").getter(getter(AuthResult::authInfo)).setter(setter(Builder::authInfo))
            .constructor(AuthInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authInfo").build()).build();

    private static final SdkField<Allowed> ALLOWED_FIELD = SdkField.<Allowed> builder(MarshallingType.SDK_POJO)
            .memberName("allowed").getter(getter(AuthResult::allowed)).setter(setter(Builder::allowed))
            .constructor(Allowed::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowed").build()).build();

    private static final SdkField<Denied> DENIED_FIELD = SdkField.<Denied> builder(MarshallingType.SDK_POJO).memberName("denied")
            .getter(getter(AuthResult::denied)).setter(setter(Builder::denied)).constructor(Denied::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denied").build()).build();

    private static final SdkField<String> AUTH_DECISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authDecision").getter(getter(AuthResult::authDecisionAsString)).setter(setter(Builder::authDecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authDecision").build()).build();

    private static final SdkField<List<String>> MISSING_CONTEXT_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("missingContextValues")
            .getter(getter(AuthResult::missingContextValues))
            .setter(setter(Builder::missingContextValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingContextValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_INFO_FIELD,
            ALLOWED_FIELD, DENIED_FIELD, AUTH_DECISION_FIELD, MISSING_CONTEXT_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AuthInfo authInfo;

    private final Allowed allowed;

    private final Denied denied;

    private final String authDecision;

    private final List<String> missingContextValues;

    private AuthResult(BuilderImpl builder) {
        this.authInfo = builder.authInfo;
        this.allowed = builder.allowed;
        this.denied = builder.denied;
        this.authDecision = builder.authDecision;
        this.missingContextValues = builder.missingContextValues;
    }

    /**
     * <p>
     * Authorization information.
     * </p>
     * 
     * @return Authorization information.
     */
    public final AuthInfo authInfo() {
        return authInfo;
    }

    /**
     * <p>
     * The policies and statements that allowed the specified action.
     * </p>
     * 
     * @return The policies and statements that allowed the specified action.
     */
    public final Allowed allowed() {
        return allowed;
    }

    /**
     * <p>
     * The policies and statements that denied the specified action.
     * </p>
     * 
     * @return The policies and statements that denied the specified action.
     */
    public final Denied denied() {
        return denied;
    }

    /**
     * <p>
     * The final authorization decision of this scenario. Multiple statements are taken into account when determining
     * the authorization decision. An explicit deny statement can override multiple allow statements.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authDecision} will
     * return {@link AuthDecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authDecisionAsString}.
     * </p>
     * 
     * @return The final authorization decision of this scenario. Multiple statements are taken into account when
     *         determining the authorization decision. An explicit deny statement can override multiple allow
     *         statements.
     * @see AuthDecision
     */
    public final AuthDecision authDecision() {
        return AuthDecision.fromValue(authDecision);
    }

    /**
     * <p>
     * The final authorization decision of this scenario. Multiple statements are taken into account when determining
     * the authorization decision. An explicit deny statement can override multiple allow statements.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authDecision} will
     * return {@link AuthDecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authDecisionAsString}.
     * </p>
     * 
     * @return The final authorization decision of this scenario. Multiple statements are taken into account when
     *         determining the authorization decision. An explicit deny statement can override multiple allow
     *         statements.
     * @see AuthDecision
     */
    public final String authDecisionAsString() {
        return authDecision;
    }

    /**
     * For responses, this returns true if the service returned a value for the MissingContextValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMissingContextValues() {
        return missingContextValues != null && !(missingContextValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains any missing context values found while evaluating policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMissingContextValues} method.
     * </p>
     * 
     * @return Contains any missing context values found while evaluating policy.
     */
    public final List<String> missingContextValues() {
        return missingContextValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authInfo());
        hashCode = 31 * hashCode + Objects.hashCode(allowed());
        hashCode = 31 * hashCode + Objects.hashCode(denied());
        hashCode = 31 * hashCode + Objects.hashCode(authDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMissingContextValues() ? missingContextValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthResult)) {
            return false;
        }
        AuthResult other = (AuthResult) obj;
        return Objects.equals(authInfo(), other.authInfo()) && Objects.equals(allowed(), other.allowed())
                && Objects.equals(denied(), other.denied())
                && Objects.equals(authDecisionAsString(), other.authDecisionAsString())
                && hasMissingContextValues() == other.hasMissingContextValues()
                && Objects.equals(missingContextValues(), other.missingContextValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthResult").add("AuthInfo", authInfo()).add("Allowed", allowed()).add("Denied", denied())
                .add("AuthDecision", authDecisionAsString())
                .add("MissingContextValues", hasMissingContextValues() ? missingContextValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authInfo":
            return Optional.ofNullable(clazz.cast(authInfo()));
        case "allowed":
            return Optional.ofNullable(clazz.cast(allowed()));
        case "denied":
            return Optional.ofNullable(clazz.cast(denied()));
        case "authDecision":
            return Optional.ofNullable(clazz.cast(authDecisionAsString()));
        case "missingContextValues":
            return Optional.ofNullable(clazz.cast(missingContextValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authInfo", AUTH_INFO_FIELD);
        map.put("allowed", ALLOWED_FIELD);
        map.put("denied", DENIED_FIELD);
        map.put("authDecision", AUTH_DECISION_FIELD);
        map.put("missingContextValues", MISSING_CONTEXT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthResult, T> g) {
        return obj -> g.apply((AuthResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthResult> {
        /**
         * <p>
         * Authorization information.
         * </p>
         * 
         * @param authInfo
         *        Authorization information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authInfo(AuthInfo authInfo);

        /**
         * <p>
         * Authorization information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthInfo.Builder} avoiding the need to
         * create one manually via {@link AuthInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #authInfo(AuthInfo)}.
         * 
         * @param authInfo
         *        a consumer that will call methods on {@link AuthInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authInfo(AuthInfo)
         */
        default Builder authInfo(Consumer<AuthInfo.Builder> authInfo) {
            return authInfo(AuthInfo.builder().applyMutation(authInfo).build());
        }

        /**
         * <p>
         * The policies and statements that allowed the specified action.
         * </p>
         * 
         * @param allowed
         *        The policies and statements that allowed the specified action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowed(Allowed allowed);

        /**
         * <p>
         * The policies and statements that allowed the specified action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Allowed.Builder} avoiding the need to
         * create one manually via {@link Allowed#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Allowed.Builder#build()} is called immediately and its result is
         * passed to {@link #allowed(Allowed)}.
         * 
         * @param allowed
         *        a consumer that will call methods on {@link Allowed.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowed(Allowed)
         */
        default Builder allowed(Consumer<Allowed.Builder> allowed) {
            return allowed(Allowed.builder().applyMutation(allowed).build());
        }

        /**
         * <p>
         * The policies and statements that denied the specified action.
         * </p>
         * 
         * @param denied
         *        The policies and statements that denied the specified action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denied(Denied denied);

        /**
         * <p>
         * The policies and statements that denied the specified action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Denied.Builder} avoiding the need to
         * create one manually via {@link Denied#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Denied.Builder#build()} is called immediately and its result is
         * passed to {@link #denied(Denied)}.
         * 
         * @param denied
         *        a consumer that will call methods on {@link Denied.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #denied(Denied)
         */
        default Builder denied(Consumer<Denied.Builder> denied) {
            return denied(Denied.builder().applyMutation(denied).build());
        }

        /**
         * <p>
         * The final authorization decision of this scenario. Multiple statements are taken into account when
         * determining the authorization decision. An explicit deny statement can override multiple allow statements.
         * </p>
         * 
         * @param authDecision
         *        The final authorization decision of this scenario. Multiple statements are taken into account when
         *        determining the authorization decision. An explicit deny statement can override multiple allow
         *        statements.
         * @see AuthDecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthDecision
         */
        Builder authDecision(String authDecision);

        /**
         * <p>
         * The final authorization decision of this scenario. Multiple statements are taken into account when
         * determining the authorization decision. An explicit deny statement can override multiple allow statements.
         * </p>
         * 
         * @param authDecision
         *        The final authorization decision of this scenario. Multiple statements are taken into account when
         *        determining the authorization decision. An explicit deny statement can override multiple allow
         *        statements.
         * @see AuthDecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthDecision
         */
        Builder authDecision(AuthDecision authDecision);

        /**
         * <p>
         * Contains any missing context values found while evaluating policy.
         * </p>
         * 
         * @param missingContextValues
         *        Contains any missing context values found while evaluating policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingContextValues(Collection<String> missingContextValues);

        /**
         * <p>
         * Contains any missing context values found while evaluating policy.
         * </p>
         * 
         * @param missingContextValues
         *        Contains any missing context values found while evaluating policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingContextValues(String... missingContextValues);
    }

    static final class BuilderImpl implements Builder {
        private AuthInfo authInfo;

        private Allowed allowed;

        private Denied denied;

        private String authDecision;

        private List<String> missingContextValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthResult model) {
            authInfo(model.authInfo);
            allowed(model.allowed);
            denied(model.denied);
            authDecision(model.authDecision);
            missingContextValues(model.missingContextValues);
        }

        public final AuthInfo.Builder getAuthInfo() {
            return authInfo != null ? authInfo.toBuilder() : null;
        }

        public final void setAuthInfo(AuthInfo.BuilderImpl authInfo) {
            this.authInfo = authInfo != null ? authInfo.build() : null;
        }

        @Override
        public final Builder authInfo(AuthInfo authInfo) {
            this.authInfo = authInfo;
            return this;
        }

        public final Allowed.Builder getAllowed() {
            return allowed != null ? allowed.toBuilder() : null;
        }

        public final void setAllowed(Allowed.BuilderImpl allowed) {
            this.allowed = allowed != null ? allowed.build() : null;
        }

        @Override
        public final Builder allowed(Allowed allowed) {
            this.allowed = allowed;
            return this;
        }

        public final Denied.Builder getDenied() {
            return denied != null ? denied.toBuilder() : null;
        }

        public final void setDenied(Denied.BuilderImpl denied) {
            this.denied = denied != null ? denied.build() : null;
        }

        @Override
        public final Builder denied(Denied denied) {
            this.denied = denied;
            return this;
        }

        public final String getAuthDecision() {
            return authDecision;
        }

        public final void setAuthDecision(String authDecision) {
            this.authDecision = authDecision;
        }

        @Override
        public final Builder authDecision(String authDecision) {
            this.authDecision = authDecision;
            return this;
        }

        @Override
        public final Builder authDecision(AuthDecision authDecision) {
            this.authDecision(authDecision == null ? null : authDecision.toString());
            return this;
        }

        public final Collection<String> getMissingContextValues() {
            if (missingContextValues instanceof SdkAutoConstructList) {
                return null;
            }
            return missingContextValues;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = MissingContextValuesCopier.copy(missingContextValues);
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = MissingContextValuesCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String... missingContextValues) {
            missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        @Override
        public AuthResult build() {
            return new AuthResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
