/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AuditNotificationTargetConfigurationsCopier {
    static Map<String, AuditNotificationTarget> copy(
            Map<String, ? extends AuditNotificationTarget> auditNotificationTargetConfigurationsParam) {
        Map<String, AuditNotificationTarget> map;
        if (auditNotificationTargetConfigurationsParam == null
                || auditNotificationTargetConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AuditNotificationTarget> modifiableMap = new LinkedHashMap<>(
                    auditNotificationTargetConfigurationsParam.size());
            auditNotificationTargetConfigurationsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AuditNotificationTarget> copyFromBuilder(
            Map<String, ? extends AuditNotificationTarget.Builder> auditNotificationTargetConfigurationsParam) {
        Map<String, AuditNotificationTarget> map;
        if (auditNotificationTargetConfigurationsParam == null
                || auditNotificationTargetConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AuditNotificationTarget> modifiableMap = new LinkedHashMap<>(
                    auditNotificationTargetConfigurationsParam.size());
            auditNotificationTargetConfigurationsParam.forEach((key, value) -> {
                AuditNotificationTarget member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AuditNotificationTarget.Builder> copyToBuilder(
            Map<String, ? extends AuditNotificationTarget> auditNotificationTargetConfigurationsParam) {
        Map<String, AuditNotificationTarget.Builder> map;
        if (auditNotificationTargetConfigurationsParam == null
                || auditNotificationTargetConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AuditNotificationTarget.Builder> modifiableMap = new LinkedHashMap<>(
                    auditNotificationTargetConfigurationsParam.size());
            auditNotificationTargetConfigurationsParam.forEach((key, value) -> {
                AuditNotificationTarget.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, AuditNotificationTarget> copyEnumToString(
            Map<AuditNotificationType, ? extends AuditNotificationTarget> auditNotificationTargetConfigurationsParam) {
        Map<String, AuditNotificationTarget> map;
        if (auditNotificationTargetConfigurationsParam == null
                || auditNotificationTargetConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, AuditNotificationTarget> modifiableMap = new LinkedHashMap<>(
                    auditNotificationTargetConfigurationsParam.size());
            auditNotificationTargetConfigurationsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<AuditNotificationType, AuditNotificationTarget> copyStringToEnum(
            Map<String, ? extends AuditNotificationTarget> auditNotificationTargetConfigurationsParam) {
        Map<AuditNotificationType, AuditNotificationTarget> map;
        if (auditNotificationTargetConfigurationsParam == null
                || auditNotificationTargetConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<AuditNotificationType, AuditNotificationTarget> modifiableMap = new LinkedHashMap<>(
                    auditNotificationTargetConfigurationsParam.size());
            auditNotificationTargetConfigurationsParam.forEach((key, value) -> {
                AuditNotificationType result = AuditNotificationType.fromValue(key);
                if (result != AuditNotificationType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
