/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the audit check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditCheckDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditCheckDetails.Builder, AuditCheckDetails> {
    private static final SdkField<String> CHECK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkRunStatus").getter(getter(AuditCheckDetails::checkRunStatusAsString))
            .setter(setter(Builder::checkRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkRunStatus").build()).build();

    private static final SdkField<Boolean> CHECK_COMPLIANT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("checkCompliant").getter(getter(AuditCheckDetails::checkCompliant))
            .setter(setter(Builder::checkCompliant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkCompliant").build()).build();

    private static final SdkField<Long> TOTAL_RESOURCES_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalResourcesCount").getter(getter(AuditCheckDetails::totalResourcesCount))
            .setter(setter(Builder::totalResourcesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResourcesCount").build())
            .build();

    private static final SdkField<Long> NON_COMPLIANT_RESOURCES_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("nonCompliantResourcesCount")
            .getter(getter(AuditCheckDetails::nonCompliantResourcesCount))
            .setter(setter(Builder::nonCompliantResourcesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantResourcesCount").build())
            .build();

    private static final SdkField<Long> SUPPRESSED_NON_COMPLIANT_RESOURCES_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("suppressedNonCompliantResourcesCount")
            .getter(getter(AuditCheckDetails::suppressedNonCompliantResourcesCount))
            .setter(setter(Builder::suppressedNonCompliantResourcesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("suppressedNonCompliantResourcesCount").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(AuditCheckDetails::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AuditCheckDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_RUN_STATUS_FIELD,
            CHECK_COMPLIANT_FIELD, TOTAL_RESOURCES_COUNT_FIELD, NON_COMPLIANT_RESOURCES_COUNT_FIELD,
            SUPPRESSED_NON_COMPLIANT_RESOURCES_COUNT_FIELD, ERROR_CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String checkRunStatus;

    private final Boolean checkCompliant;

    private final Long totalResourcesCount;

    private final Long nonCompliantResourcesCount;

    private final Long suppressedNonCompliantResourcesCount;

    private final String errorCode;

    private final String message;

    private AuditCheckDetails(BuilderImpl builder) {
        this.checkRunStatus = builder.checkRunStatus;
        this.checkCompliant = builder.checkCompliant;
        this.totalResourcesCount = builder.totalResourcesCount;
        this.nonCompliantResourcesCount = builder.nonCompliantResourcesCount;
        this.suppressedNonCompliantResourcesCount = builder.suppressedNonCompliantResourcesCount;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkRunStatus}
     * will return {@link AuditCheckRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checkRunStatusAsString}.
     * </p>
     * 
     * @return The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     *         "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * @see AuditCheckRunStatus
     */
    public final AuditCheckRunStatus checkRunStatus() {
        return AuditCheckRunStatus.fromValue(checkRunStatus);
    }

    /**
     * <p>
     * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkRunStatus}
     * will return {@link AuditCheckRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checkRunStatusAsString}.
     * </p>
     * 
     * @return The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     *         "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * @see AuditCheckRunStatus
     */
    public final String checkRunStatusAsString() {
        return checkRunStatus;
    }

    /**
     * <p>
     * True if the check is complete and found all resources compliant.
     * </p>
     * 
     * @return True if the check is complete and found all resources compliant.
     */
    public final Boolean checkCompliant() {
        return checkCompliant;
    }

    /**
     * <p>
     * The number of resources on which the check was performed.
     * </p>
     * 
     * @return The number of resources on which the check was performed.
     */
    public final Long totalResourcesCount() {
        return totalResourcesCount;
    }

    /**
     * <p>
     * The number of resources that were found noncompliant during the check.
     * </p>
     * 
     * @return The number of resources that were found noncompliant during the check.
     */
    public final Long nonCompliantResourcesCount() {
        return nonCompliantResourcesCount;
    }

    /**
     * <p>
     * Describes how many of the non-compliant resources created during the evaluation of an audit check were marked as
     * suppressed.
     * </p>
     * 
     * @return Describes how many of the non-compliant resources created during the evaluation of an audit check were
     *         marked as suppressed.
     */
    public final Long suppressedNonCompliantResourcesCount() {
        return suppressedNonCompliantResourcesCount;
    }

    /**
     * <p>
     * The code of any error encountered when this check is performed during this audit. One of
     * "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
     * </p>
     * 
     * @return The code of any error encountered when this check is performed during this audit. One of
     *         "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The message associated with any error encountered when this check is performed during this audit.
     * </p>
     * 
     * @return The message associated with any error encountered when this check is performed during this audit.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(checkCompliant());
        hashCode = 31 * hashCode + Objects.hashCode(totalResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(suppressedNonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditCheckDetails)) {
            return false;
        }
        AuditCheckDetails other = (AuditCheckDetails) obj;
        return Objects.equals(checkRunStatusAsString(), other.checkRunStatusAsString())
                && Objects.equals(checkCompliant(), other.checkCompliant())
                && Objects.equals(totalResourcesCount(), other.totalResourcesCount())
                && Objects.equals(nonCompliantResourcesCount(), other.nonCompliantResourcesCount())
                && Objects.equals(suppressedNonCompliantResourcesCount(), other.suppressedNonCompliantResourcesCount())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuditCheckDetails").add("CheckRunStatus", checkRunStatusAsString())
                .add("CheckCompliant", checkCompliant()).add("TotalResourcesCount", totalResourcesCount())
                .add("NonCompliantResourcesCount", nonCompliantResourcesCount())
                .add("SuppressedNonCompliantResourcesCount", suppressedNonCompliantResourcesCount())
                .add("ErrorCode", errorCode()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkRunStatus":
            return Optional.ofNullable(clazz.cast(checkRunStatusAsString()));
        case "checkCompliant":
            return Optional.ofNullable(clazz.cast(checkCompliant()));
        case "totalResourcesCount":
            return Optional.ofNullable(clazz.cast(totalResourcesCount()));
        case "nonCompliantResourcesCount":
            return Optional.ofNullable(clazz.cast(nonCompliantResourcesCount()));
        case "suppressedNonCompliantResourcesCount":
            return Optional.ofNullable(clazz.cast(suppressedNonCompliantResourcesCount()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("checkRunStatus", CHECK_RUN_STATUS_FIELD);
        map.put("checkCompliant", CHECK_COMPLIANT_FIELD);
        map.put("totalResourcesCount", TOTAL_RESOURCES_COUNT_FIELD);
        map.put("nonCompliantResourcesCount", NON_COMPLIANT_RESOURCES_COUNT_FIELD);
        map.put("suppressedNonCompliantResourcesCount", SUPPRESSED_NON_COMPLIANT_RESOURCES_COUNT_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditCheckDetails, T> g) {
        return obj -> g.apply((AuditCheckDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditCheckDetails> {
        /**
         * <p>
         * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * </p>
         * 
         * @param checkRunStatus
         *        The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         *        "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * @see AuditCheckRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditCheckRunStatus
         */
        Builder checkRunStatus(String checkRunStatus);

        /**
         * <p>
         * The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * </p>
         * 
         * @param checkRunStatus
         *        The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         *        "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * @see AuditCheckRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditCheckRunStatus
         */
        Builder checkRunStatus(AuditCheckRunStatus checkRunStatus);

        /**
         * <p>
         * True if the check is complete and found all resources compliant.
         * </p>
         * 
         * @param checkCompliant
         *        True if the check is complete and found all resources compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkCompliant(Boolean checkCompliant);

        /**
         * <p>
         * The number of resources on which the check was performed.
         * </p>
         * 
         * @param totalResourcesCount
         *        The number of resources on which the check was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResourcesCount(Long totalResourcesCount);

        /**
         * <p>
         * The number of resources that were found noncompliant during the check.
         * </p>
         * 
         * @param nonCompliantResourcesCount
         *        The number of resources that were found noncompliant during the check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount);

        /**
         * <p>
         * Describes how many of the non-compliant resources created during the evaluation of an audit check were marked
         * as suppressed.
         * </p>
         * 
         * @param suppressedNonCompliantResourcesCount
         *        Describes how many of the non-compliant resources created during the evaluation of an audit check were
         *        marked as suppressed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedNonCompliantResourcesCount(Long suppressedNonCompliantResourcesCount);

        /**
         * <p>
         * The code of any error encountered when this check is performed during this audit. One of
         * "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
         * </p>
         * 
         * @param errorCode
         *        The code of any error encountered when this check is performed during this audit. One of
         *        "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The message associated with any error encountered when this check is performed during this audit.
         * </p>
         * 
         * @param message
         *        The message associated with any error encountered when this check is performed during this audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String checkRunStatus;

        private Boolean checkCompliant;

        private Long totalResourcesCount;

        private Long nonCompliantResourcesCount;

        private Long suppressedNonCompliantResourcesCount;

        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditCheckDetails model) {
            checkRunStatus(model.checkRunStatus);
            checkCompliant(model.checkCompliant);
            totalResourcesCount(model.totalResourcesCount);
            nonCompliantResourcesCount(model.nonCompliantResourcesCount);
            suppressedNonCompliantResourcesCount(model.suppressedNonCompliantResourcesCount);
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getCheckRunStatus() {
            return checkRunStatus;
        }

        public final void setCheckRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
        }

        @Override
        public final Builder checkRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
            return this;
        }

        @Override
        public final Builder checkRunStatus(AuditCheckRunStatus checkRunStatus) {
            this.checkRunStatus(checkRunStatus == null ? null : checkRunStatus.toString());
            return this;
        }

        public final Boolean getCheckCompliant() {
            return checkCompliant;
        }

        public final void setCheckCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
        }

        @Override
        public final Builder checkCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
            return this;
        }

        public final Long getTotalResourcesCount() {
            return totalResourcesCount;
        }

        public final void setTotalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
        }

        @Override
        public final Builder totalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
            return this;
        }

        public final Long getNonCompliantResourcesCount() {
            return nonCompliantResourcesCount;
        }

        public final void setNonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
        }

        @Override
        public final Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
            return this;
        }

        public final Long getSuppressedNonCompliantResourcesCount() {
            return suppressedNonCompliantResourcesCount;
        }

        public final void setSuppressedNonCompliantResourcesCount(Long suppressedNonCompliantResourcesCount) {
            this.suppressedNonCompliantResourcesCount = suppressedNonCompliantResourcesCount;
        }

        @Override
        public final Builder suppressedNonCompliantResourcesCount(Long suppressedNonCompliantResourcesCount) {
            this.suppressedNonCompliantResourcesCount = suppressedNonCompliantResourcesCount;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public AuditCheckDetails build() {
            return new AuditCheckDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
