/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ThingTypeDefinition;

public class ListThingTypesPublisher
implements SdkPublisher<ListThingTypesResponse> {
    private final IotAsyncClient client;
    private final ListThingTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingTypesPublisher(IotAsyncClient client, ListThingTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingTypesPublisher(IotAsyncClient client, ListThingTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ThingTypeDefinition> thingTypes() {
        Function<ListThingTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingTypes() != null) {
                return response.thingTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingTypesResponseFetcher
    implements AsyncPageFetcher<ListThingTypesResponse> {
        private ListThingTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListThingTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingTypesResponse> nextPage(ListThingTypesResponse previousPage) {
            if (previousPage == null) {
                return ListThingTypesPublisher.this.client.listThingTypes(ListThingTypesPublisher.this.firstRequest);
            }
            return ListThingTypesPublisher.this.client.listThingTypes((ListThingTypesRequest)((Object)ListThingTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

