/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Request;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Response;
import software.amazon.awssdk.services.iot.model.ThingPrincipalObject;

public class ListThingPrincipalsV2Publisher
implements SdkPublisher<ListThingPrincipalsV2Response> {
    private final IotAsyncClient client;
    private final ListThingPrincipalsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingPrincipalsV2Publisher(IotAsyncClient client, ListThingPrincipalsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingPrincipalsV2Publisher(IotAsyncClient client, ListThingPrincipalsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingPrincipalsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingPrincipalsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ThingPrincipalObject> thingPrincipalObjects() {
        Function<ListThingPrincipalsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.thingPrincipalObjects() != null) {
                return response.thingPrincipalObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingPrincipalsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingPrincipalsV2ResponseFetcher
    implements AsyncPageFetcher<ListThingPrincipalsV2Response> {
        private ListThingPrincipalsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListThingPrincipalsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingPrincipalsV2Response> nextPage(ListThingPrincipalsV2Response previousPage) {
            if (previousPage == null) {
                return ListThingPrincipalsV2Publisher.this.client.listThingPrincipalsV2(ListThingPrincipalsV2Publisher.this.firstRequest);
            }
            return ListThingPrincipalsV2Publisher.this.client.listThingPrincipalsV2((ListThingPrincipalsV2Request)((Object)ListThingPrincipalsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

