/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.MitigationActionParams;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMitigationActionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateMitigationActionRequest> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(UpdateMitigationActionRequest.getter(UpdateMitigationActionRequest::actionName)).setter(UpdateMitigationActionRequest.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateMitigationActionRequest.getter(UpdateMitigationActionRequest::roleArn)).setter(UpdateMitigationActionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<MitigationActionParams> ACTION_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionParams").getter(UpdateMitigationActionRequest.getter(UpdateMitigationActionRequest::actionParams)).setter(UpdateMitigationActionRequest.setter(Builder::actionParams)).constructor(MitigationActionParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, ROLE_ARN_FIELD, ACTION_PARAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMitigationActionRequest.memberNameToFieldInitializer();
    private final String actionName;
    private final String roleArn;
    private final MitigationActionParams actionParams;

    private UpdateMitigationActionRequest(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.roleArn = builder.roleArn;
        this.actionParams = builder.actionParams;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MitigationActionParams actionParams() {
        return this.actionParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMitigationActionRequest)) {
            return false;
        }
        UpdateMitigationActionRequest other = (UpdateMitigationActionRequest)((Object)obj);
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.actionParams(), other.actionParams());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMitigationActionRequest").add("ActionName", (Object)this.actionName()).add("RoleArn", (Object)this.roleArn()).add("ActionParams", (Object)this.actionParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "actionParams": {
                return Optional.ofNullable(clazz.cast(this.actionParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("actionParams", ACTION_PARAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMitigationActionRequest, T> g) {
        return obj -> g.apply((UpdateMitigationActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String actionName;
        private String roleArn;
        private MitigationActionParams actionParams;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMitigationActionRequest model) {
            super(model);
            this.actionName(model.actionName);
            this.roleArn(model.roleArn);
            this.actionParams(model.actionParams);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MitigationActionParams.Builder getActionParams() {
            return this.actionParams != null ? this.actionParams.toBuilder() : null;
        }

        public final void setActionParams(MitigationActionParams.BuilderImpl actionParams) {
            this.actionParams = actionParams != null ? actionParams.build() : null;
        }

        @Override
        public final Builder actionParams(MitigationActionParams actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMitigationActionRequest build() {
            return new UpdateMitigationActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMitigationActionRequest> {
        public Builder actionName(String var1);

        public Builder roleArn(String var1);

        public Builder actionParams(MitigationActionParams var1);

        default public Builder actionParams(Consumer<MitigationActionParams.Builder> actionParams) {
            return this.actionParams((MitigationActionParams)((MitigationActionParams.Builder)MitigationActionParams.builder().applyMutation(actionParams)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

