/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuditNotificationType {
    SNS("SNS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuditNotificationType> VALUE_MAP;
    private final String value;

    private AuditNotificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuditNotificationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuditNotificationType> knownValues() {
        EnumSet<AuditNotificationType> knownValues = EnumSet.allOf(AuditNotificationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuditNotificationType.class, AuditNotificationType::toString);
    }
}

